/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.user;

import com.dev7ex.common.bukkit.plugin.service.PluginService;
import com.dev7ex.multiworld.user.WorldUser;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class WorldUserService
implements PluginService {
    private final Map<UUID, WorldUser> users = Maps.newHashMap();

    @Override
    public void onEnable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            WorldUser worldUser = new WorldUser(player.getUniqueId());
            this.users.put(player.getUniqueId(), worldUser);
        }
    }

    @Override
    public void onDisable() {
        this.users.clear();
    }

    public void registerUser(WorldUser worldUser) {
        this.users.put(worldUser.getUniqueId(), worldUser);
    }

    public void removeUser(UUID uniqueId) {
        this.users.remove(uniqueId);
    }

    public Map<UUID, WorldUser> getUsers() {
        return this.users;
    }
}

