/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.event.MultiWorldListener;
import com.dev7ex.multiworld.world.WorldProperties;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public final class EntityDamageByEntityListener
extends MultiWorldListener {
    public EntityDamageByEntityListener(MultiWorldPlugin multiWorldPlugin) {
        super(multiWorldPlugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handleEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Arrow arrow;
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        WorldProperties worldProperties = super.getWorldManager().getWorldProperties().get(player.getWorld().getName());
        if (worldProperties == null) {
            return;
        }
        if (worldProperties.isPvpEnabled()) {
            return;
        }
        if (event.getDamager().getType() == EntityType.PLAYER) {
            event.setCancelled(true);
        }
        if (event.getDamager().getType() == EntityType.ARROW && (arrow = (Arrow)event.getDamager()).getShooter() instanceof Player) {
            event.setCancelled(true);
        }
    }
}

