/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class UnloadCommand
extends WorldSubCommand
implements TabCompleter {
    public UnloadCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world unload <World>"));
        super.setPermission("multiworld.command.world.unload");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 2) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        if (arguments[1].equalsIgnoreCase(MultiWorldPlugin.getInstance().getConfiguration().getDefaultWorldName())) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.cannot-unloaded").replaceAll("%world%", arguments[1]));
            return true;
        }
        if (!this.worldManager.getWorldConfiguration().isWorldRegistered(arguments[1])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.not-exists").replaceAll("%world%", arguments[1]));
            return true;
        }
        if (Bukkit.getWorld((String)arguments[1]) == null) {
            commandSender.sendMessage(this.configuration.getWorldMessage("loading.not-loaded").replaceAll("%world%", arguments[1]));
            return true;
        }
        this.worldManager.unloadWorld(commandSender, arguments[1]);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        ArrayList loadedWorlds = Lists.newArrayList(this.worldManager.getWorldProperties().keySet());
        loadedWorlds.remove(this.plugin.getConfiguration().getStringSafe("defaults.world"));
        return loadedWorlds;
    }
}

