/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class TeleportCommand
extends WorldSubCommand
implements TabCompleter {
    public TeleportCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world teleport <Player> <World>"));
        super.setAliases(Collections.singletonList("tp"));
        super.setPermission("multiworld.command.world.teleport");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 3) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        if (!this.worldManager.getWorldProperties().containsKey(arguments[2])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.not-exists").replaceAll("%world%", arguments[1]));
            return true;
        }
        World world = Bukkit.getWorld((String)arguments[2]);
        if (world == null) {
            commandSender.sendMessage(this.configuration.getWorldMessage("loading.not-loaded").replaceAll("%world%", arguments[1]));
            return true;
        }
        Player target = Bukkit.getPlayer((String)arguments[1]);
        if (target == null) {
            commandSender.sendMessage(super.getPlayerNotFoundMessage());
            return true;
        }
        if (target.getWorld().getName().equalsIgnoreCase(arguments[2])) {
            if (commandSender.getName().equalsIgnoreCase(target.getName())) {
                commandSender.sendMessage(this.configuration.getWorldMessage("teleport.sender-already-in-world").replaceAll("%world%", arguments[1]));
                return true;
            }
            commandSender.sendMessage(this.configuration.getWorldMessage("teleport.target-already-in-world").replaceAll("%target%", target.getName()).replaceAll("%world%", arguments[1]));
            return true;
        }
        this.worldManager.teleportWorld(commandSender, target, world.getSpawnLocation());
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        if (arguments.length != 3) {
            return null;
        }
        ArrayList completions = Lists.newArrayList(this.worldManager.getWorldProperties().keySet());
        if (commandSender instanceof Player) {
            completions.remove(((Player)commandSender).getWorld().getName());
        }
        return completions;
    }
}

