/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.java.reference.Reference;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.dev7ex.multiworld.world.WorldOption;
import com.dev7ex.multiworld.world.WorldProperties;
import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class OptionsCommand
extends WorldSubCommand
implements TabCompleter {
    public OptionsCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world options <World> <Option> <Value>"));
        super.setPermission("multiworld.command.world.options");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(super.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 4) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        if (!this.worldManager.getWorldProperties().containsKey(arguments[1])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.not-exists").replaceAll("%world%", arguments[1]));
            return true;
        }
        Reference<WorldOption> optionReference = new Reference<WorldOption>();
        try {
            optionReference.setValue(WorldOption.valueOf(arguments[2].toUpperCase()));
        }
        catch (IllegalArgumentException exception) {
            commandSender.sendMessage(this.configuration.getWorldMessage("options.not-available"));
            return true;
        }
        WorldProperties worldProperties = this.worldManager.getWorldProperties().get(arguments[1]);
        if (!((WorldOption)((Object)optionReference.getValue())).getValues().contains(arguments[3])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("options.value-wrong").replaceAll("%value%", arguments[3]));
            return true;
        }
        commandSender.sendMessage(this.configuration.getWorldMessage("options.updating").replaceAll("%option%", ((WorldOption)((Object)optionReference.getValue())).toString()).replaceAll("%value%", arguments[3]).replaceAll("%world%", arguments[1]));
        worldProperties.updateWorldOption((WorldOption)((Object)optionReference.getValue()), arguments[3]);
        this.worldManager.getWorldConfiguration().updateWorldOption(worldProperties.getWorldName(), (WorldOption)((Object)optionReference.getValue()), arguments[3]);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        if (arguments.length == 2) {
            return Lists.newArrayList(this.worldManager.getWorldProperties().keySet());
        }
        if (arguments.length == 3) {
            return WorldOption.toStringList();
        }
        Reference<WorldOption> optionReference = new Reference<WorldOption>();
        try {
            optionReference.setValue(WorldOption.valueOf(arguments[2].toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (optionReference.getValue() == null) {
            return null;
        }
        return Lists.newArrayList(((WorldOption)((Object)optionReference.getValue())).getValues());
    }
}

