/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.google.common.collect.Lists;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class LoadCommand
extends WorldSubCommand
implements TabCompleter {
    public LoadCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world load <World>"));
        super.setPermission("multiworld.command.world.load");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 2) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        if (Bukkit.getWorld((String)arguments[1]) != null) {
            commandSender.sendMessage(this.configuration.getWorldMessage("loading.already-loaded").replaceAll("%world%", arguments[1]));
            return true;
        }
        if (!this.worldManager.getWorldConfiguration().isWorldRegistered(arguments[1])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.not-exists").replaceAll("%world%", arguments[1]));
            return true;
        }
        this.worldManager.loadWorld(commandSender, arguments[1]);
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            player.spigot().sendMessage((BaseComponent)this.getTeleportComponent(player, arguments[1]));
        }
        return true;
    }

    public TextComponent getTeleportComponent(Player player, String world) {
        TextComponent textComponent = new TextComponent(this.configuration.getWorldMessage("teleport.component-message"));
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.configuration.getWorldMessage("teleport.component-hover-text"))}));
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/world teleport " + player.getName() + " " + world));
        return textComponent;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        return Lists.newArrayList(this.worldManager.getWorldProperties().keySet());
    }
}

