/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.dev7ex.multiworld.world.WorldProperties;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public final class ListCommand
extends WorldSubCommand {
    public ListCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world list"));
        super.setPermission("multiworld.command.world.list");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 1) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> worldSet = this.worldManager.getWorldProperties().keySet();
        for (String world : worldSet) {
            WorldProperties worldProperties = this.worldManager.getWorldProperties().get(world);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(ChatColor.WHITE);
                stringBuilder.append(", ");
            }
            stringBuilder.append(worldProperties.isLoaded() ? ChatColor.GREEN : ChatColor.RED).append(world);
        }
        commandSender.sendMessage(this.configuration.getWorldMessage("list.message").replaceAll("%worlds%", stringBuilder.toString()));
        return true;
    }
}

