/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.dev7ex.multiworld.world.WorldProperties;
import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class InfoCommand
extends WorldSubCommand
implements TabCompleter {
    public InfoCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world info <World>"));
        super.setPermission("multiworld.command.world.info");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(super.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 2) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        if (!this.worldManager.getWorldProperties().containsKey(arguments[1])) {
            commandSender.sendMessage(this.configuration.getMessage("world-doesnt-exist").replaceAll("%world%", arguments[1]));
            return true;
        }
        WorldProperties worldProperties = this.worldManager.getWorldProperties().get(arguments[1]);
        this.configuration.getStringList("messages.world.info").forEach(message -> commandSender.sendMessage(message.replaceAll("%world%", arguments[1]).replaceAll("%worldCreator%", worldProperties.getWorldCreator()).replaceAll("%creationDate%", worldProperties.formatCreationDate(worldProperties.getCreationTime())).replaceAll("%loaded%", worldProperties.isLoaded() ? "true" : "false").replaceAll("%worldType%", worldProperties.getWorldType().toString()).replaceAll("%environment%", worldProperties.getWorldType().getEnvironment().toString()).replaceAll("%difficulty%", worldProperties.getDifficulty().toString()).replaceAll("%gameMode%", worldProperties.getGameMode().toString()).replaceAll("%pvpEnabled%", worldProperties.isPvpEnabled() ? "true" : "false")));
        return true;
    }

    public final List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        return Lists.newArrayList(this.worldManager.getWorldProperties().keySet());
    }
}

