/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.java.reference.Reference;
import com.dev7ex.common.java.util.FileUtil;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.dev7ex.multiworld.world.WorldType;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class ImportCommand
extends WorldSubCommand
implements TabCompleter {
    public ImportCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world import <Name> <WorldType>"));
        super.setPermission("multiworld.command.world.import");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 3) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        File worldFolder = new File(Bukkit.getWorldContainer(), arguments[1]);
        if (!FileUtil.containsFile(worldFolder, "level.dat")) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.folder-not-exists").replaceAll("%folder%", arguments[1]));
            return true;
        }
        if (this.worldManager.getWorldProperties().containsKey(arguments[1])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("import.already-imported").replaceAll("%world%", arguments[1]));
            return true;
        }
        Reference<WorldType> worldTypeReference = new Reference<WorldType>();
        try {
            worldTypeReference.setValue(WorldType.valueOf(arguments[2].toUpperCase()));
        }
        catch (IllegalArgumentException exception) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.type-not-available"));
            return true;
        }
        this.worldManager.importWorld(commandSender, arguments[1], (WorldType)((Object)worldTypeReference.getValue()));
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        if (arguments.length < 2 || arguments.length > 3) {
            return null;
        }
        if (arguments.length == 3) {
            return WorldType.toStringList();
        }
        List<String> files = FileUtil.foldersToStringList(Bukkit.getWorldContainer());
        ArrayList completions = Lists.newArrayList(files);
        for (File folder : Objects.requireNonNull(Bukkit.getWorldContainer().listFiles())) {
            if (FileUtil.containsFile(folder, "level.dat")) continue;
            completions.remove(folder.getName());
        }
        return completions;
    }
}

