/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.java.util.FileUtil;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class DeleteCommand
extends WorldSubCommand
implements TabCompleter {
    public DeleteCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world delete <Name>"));
        super.setPermission("multiworld.command.world.delete");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 2) {
            commandSender.sendMessage(super.getPrefix() + super.getUsage());
            return true;
        }
        File worldFolder = new File(Bukkit.getWorldContainer(), arguments[1]);
        if (!worldFolder.exists()) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.folder-not-exists").replaceAll("%folder%", arguments[1]));
            return true;
        }
        if (!FileUtil.containsFile(worldFolder, "level.dat")) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.folder-not-exists").replaceAll("%folder%", arguments[1]));
            return true;
        }
        if (arguments[1].equalsIgnoreCase(MultiWorldPlugin.getInstance().getConfiguration().getDefaultWorldName())) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.cannot-deleted").replaceAll("%world%", arguments[1]));
            return true;
        }
        if (this.worldManager.isServerDeletingWorld()) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.waiting"));
            return true;
        }
        if (!this.worldManager.getWorldConfiguration().isWorldRegistered(arguments[1])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.not-exists").replaceAll("%world%", arguments[1]));
            return true;
        }
        this.worldManager.deleteWorld(commandSender, arguments[1]);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        ArrayList worlds = Lists.newArrayList(this.worldManager.getWorldProperties().keySet());
        worlds.remove(this.plugin.getConfiguration().getStringSafe("defaults.world"));
        return worlds;
    }
}

