/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.java.reference.Reference;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.dev7ex.multiworld.world.WorldType;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class CreateCommand
extends WorldSubCommand
implements TabCompleter {
    public CreateCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "/world create <Name> <Type>"));
        super.setPermission("multiworld.command.world.create");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 3) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        if (this.worldManager.getWorldProperties().containsKey(arguments[1])) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.already-exists").replaceAll("%world%", arguments[1]));
            return true;
        }
        Reference<WorldType> worldTypeReference = new Reference<WorldType>();
        try {
            worldTypeReference.setValue(WorldType.valueOf(arguments[2].toUpperCase()));
        }
        catch (IllegalArgumentException exception) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.type-not-available"));
            return true;
        }
        if (this.worldManager.isServerCreatingWorld()) {
            commandSender.sendMessage(this.configuration.getWorldMessage("general.waiting"));
            return true;
        }
        this.worldManager.createWorld(commandSender, arguments[1], (WorldType)((Object)worldTypeReference.getValue()));
        return true;
    }

    public final List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        return arguments.length == 3 ? WorldType.toStringList() : null;
    }
}

