/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.WorldSubCommand;
import com.dev7ex.multiworld.user.WorldUser;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BackCommand
extends WorldSubCommand {
    public BackCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setUsage(plugin.getConfiguration().getUsage().replaceAll("%command%", "back"));
        super.setPermission("multiworld.command.world.back");
    }

    @Override
    public boolean execute(CommandSender commandSender, String[] arguments) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.configuration.getOnlyPlayerCommandMessage());
            return true;
        }
        Player player = (Player)commandSender;
        WorldUser worldUser = super.getWorldUser(player.getUniqueId());
        if (!player.hasPermission(super.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length != 1) {
            commandSender.sendMessage(super.getUsage());
            return true;
        }
        if (worldUser.getProperties().getLastWorld() == null) {
            player.sendMessage(this.configuration.getWorldMessage("back.world-not-found"));
            return true;
        }
        World world = Bukkit.getWorld((String)worldUser.getProperties().getLastWorld());
        if (world == null) {
            worldUser.getProperties().setLastWorld(null);
            player.sendMessage(this.configuration.getWorldMessage(this.configuration.getMessage("back.world-not-found")));
            return true;
        }
        if (worldUser.getProperties().getLastWorld().equalsIgnoreCase(player.getWorld().getName())) {
            player.sendMessage(this.configuration.getWorldMessage("back.world-already-there"));
            return true;
        }
        Location teleportLocation = worldUser.getProperties().getLastWorldLocation() == null ? world.getSpawnLocation() : worldUser.getProperties().getLastWorldLocation();
        this.worldManager.teleportWorld(player, teleportLocation);
        return true;
    }
}

