/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command;

import com.dev7ex.common.bukkit.command.SimpleCommand;
import com.dev7ex.common.bukkit.command.SubCommand;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.world.BackCommand;
import com.dev7ex.multiworld.command.world.CreateCommand;
import com.dev7ex.multiworld.command.world.DeleteCommand;
import com.dev7ex.multiworld.command.world.HelpCommand;
import com.dev7ex.multiworld.command.world.ImportCommand;
import com.dev7ex.multiworld.command.world.InfoCommand;
import com.dev7ex.multiworld.command.world.ListCommand;
import com.dev7ex.multiworld.command.world.LoadCommand;
import com.dev7ex.multiworld.command.world.OptionsCommand;
import com.dev7ex.multiworld.command.world.TeleportCommand;
import com.dev7ex.multiworld.command.world.UnloadCommand;
import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class WorldCommand
extends SimpleCommand
implements TabCompleter {
    public WorldCommand(MultiWorldPlugin plugin) {
        super(plugin);
        super.setPermission("multiworld.command.world");
        super.registerSubCommand(new BackCommand(plugin));
        super.registerSubCommand(new CreateCommand(plugin));
        super.registerSubCommand(new DeleteCommand(plugin));
        super.registerSubCommand(new InfoCommand(plugin));
        super.registerSubCommand(new HelpCommand(plugin));
        super.registerSubCommand(new ImportCommand(plugin));
        super.registerSubCommand(new ListCommand(plugin));
        super.registerSubCommand(new LoadCommand(plugin));
        super.registerSubCommand(new OptionsCommand(plugin));
        super.registerSubCommand(new TeleportCommand(plugin));
        super.registerSubCommand(new UnloadCommand(plugin));
    }

    public boolean onCommand(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        if (!commandSender.hasPermission(super.getPermission())) {
            commandSender.sendMessage(super.getNoPermissionMessage());
            return true;
        }
        if (arguments.length == 0 || arguments.length > 4) {
            return this.commandMap.get("help").execute(commandSender, arguments);
        }
        SubCommand subCommand = this.commandMap.get(arguments[0].toLowerCase());
        if (subCommand == null) {
            this.commandMap.get("help").execute(commandSender, arguments);
            return true;
        }
        return subCommand.execute(commandSender, arguments);
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String commandLabel, String[] arguments) {
        if (arguments.length == 1) {
            return Lists.newArrayList(this.commandMap.keySet());
        }
        SubCommand subCommand = this.commandMap.get(arguments[0].toLowerCase());
        if (subCommand == null || !(subCommand instanceof TabCompleter)) {
            return null;
        }
        return ((TabCompleter)subCommand).onTabComplete(commandSender, command, commandLabel, arguments);
    }
}

