/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld;

import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.multiworld.MultiWorldConfiguration;
import com.dev7ex.multiworld.command.WorldCommand;
import com.dev7ex.multiworld.listener.EntityDamageByEntityListener;
import com.dev7ex.multiworld.listener.PlayerChangeWorldListener;
import com.dev7ex.multiworld.listener.PlayerConnectionListener;
import com.dev7ex.multiworld.user.WorldUserService;
import com.dev7ex.multiworld.world.WorldConfiguration;
import com.dev7ex.multiworld.world.WorldManager;
import com.dev7ex.multiworld.world.WorldService;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MultiWorldPlugin
extends BukkitPlugin {
    private static final int SERVICE_ID = 15446;
    private MultiWorldConfiguration configuration;
    private WorldConfiguration worldConfiguration;
    private WorldService worldService;
    private WorldManager worldManager;
    private WorldUserService worldUserService;

    @Override
    public void onLoad() {
        this.configuration = new MultiWorldConfiguration(this);
        super.onLoad();
        this.worldConfiguration = new WorldConfiguration((Plugin)this);
    }

    @Override
    public void onEnable() {
        this.worldUserService = new WorldUserService();
        super.registerService(this.worldUserService);
        this.worldManager = new WorldManager(this.configuration, this.worldConfiguration, this.worldUserService);
        this.worldService = new WorldService(this.worldManager, this.worldConfiguration);
        super.registerService(this.worldService);
        super.onEnable();
    }

    @Override
    public void registerCommands() {
        super.registerCommand("world").setExecutor((CommandExecutor)new WorldCommand(this));
    }

    @Override
    public void registerListeners() {
        super.registerListener(new EntityDamageByEntityListener(this));
        super.registerListenerIf(new PlayerChangeWorldListener(this), enable -> this.configuration.getBooleanSafe("settings.auto-gamemode"));
        super.registerListener(new PlayerConnectionListener(this));
    }

    public static MultiWorldPlugin getInstance() {
        return (MultiWorldPlugin)JavaPlugin.getPlugin(MultiWorldPlugin.class);
    }

    @Override
    public MultiWorldConfiguration getConfiguration() {
        return this.configuration;
    }

    public WorldConfiguration getWorldConfiguration() {
        return this.worldConfiguration;
    }

    public WorldService getWorldService() {
        return this.worldService;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public WorldUserService getWorldUserService() {
        return this.worldUserService;
    }
}

