/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld;

import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.bukkit.plugin.configuration.PluginConfiguration;
import com.dev7ex.common.java.map.ParsedMap;
import java.util.List;

public final class MultiWorldConfiguration
extends PluginConfiguration {
    public MultiWorldConfiguration(BukkitPlugin bukkitPlugin) {
        super(bukkitPlugin);
    }

    @Override
    public void load() {
        this.values.put("prefix", this.fileConfiguration.getString("prefix"));
        this.values.put("no-permission", this.fileConfiguration.getString("no-permission"));
        this.values.put("player-not-found", this.fileConfiguration.getString("player-not-found"));
        this.values.put("only-player-command", this.fileConfiguration.getString("only-player-command"));
        this.values.put("usage", this.fileConfiguration.getString("usage"));
        this.values.put("defaults.world", this.fileConfiguration.getString("defaults.world"));
        this.values.put("defaults.difficulty", this.fileConfiguration.getString("defaults.difficulty"));
        this.values.put("defaults.gameMode", this.fileConfiguration.getString("defaults.gameMode"));
        this.values.put("defaults.pvp-enabled", this.fileConfiguration.getBoolean("defaults.pvp-enabled"));
        this.values.put("defaults.spawn-animals", this.fileConfiguration.getBoolean("defaults.spawn-animals"));
        this.values.put("defaults.spawn-monsters", this.fileConfiguration.getBoolean("defaults.spawn-monsters"));
        this.values.put("settings.auto-gamemode", this.fileConfiguration.getBoolean("settings.auto-gamemode"));
        this.values.put("messages.world.back.world-already-there", this.fileConfiguration.getString("messages.world.back.world-already-there"));
        this.values.put("messages.world.back.world-not-loaded", this.fileConfiguration.getString("messages.world.back.world-not-loaded"));
        this.values.put("messages.world.back.world-not-found", this.fileConfiguration.getString("messages.world.back.world-not-found"));
        this.values.put("messages.world.general.already-exists", this.fileConfiguration.getString("messages.world.general.already-exists"));
        this.values.put("messages.world.general.type-not-available", this.fileConfiguration.getString("messages.world.general.type-not-available"));
        this.values.put("messages.world.general.waiting", this.fileConfiguration.getString("messages.world.general.waiting"));
        this.values.put("messages.world.general.cannot-deleted", this.fileConfiguration.getString("messages.world.general.cannot-deleted"));
        this.values.put("messages.world.general.cannot-unloaded", this.fileConfiguration.getString("messages.world.general.cannot-unloaded"));
        this.values.put("messages.world.general.not-exists", this.fileConfiguration.getString("messages.world.general.not-exists"));
        this.values.put("messages.world.general.error-message", this.fileConfiguration.getString("messages.world.general.error-message"));
        this.values.put("messages.world.general.folder-not-exists", this.fileConfiguration.getString("messages.world.general.folder-not-exists"));
        this.values.put("messages.world.create.starting", this.fileConfiguration.getString("messages.world.create.starting"));
        this.values.put("messages.world.create.finished", this.fileConfiguration.getString("messages.world.create.finished"));
        this.values.put("messages.world.delete.starting", this.fileConfiguration.getString("messages.world.delete.starting"));
        this.values.put("messages.world.delete.finished", this.fileConfiguration.getString("messages.world.delete.finished"));
        this.values.put("messages.world.list.message", this.fileConfiguration.getString("messages.world.list.message"));
        this.values.put("messages.world.import.already-imported", this.fileConfiguration.getString("messages.world.import.already-imported"));
        this.values.put("messages.world.import.starting", this.fileConfiguration.getString("messages.world.import.starting"));
        this.values.put("messages.world.import.finished", this.fileConfiguration.getString("messages.world.import.finished"));
        this.values.put("messages.world.unloading.starting", this.fileConfiguration.getString("messages.world.unloading.starting"));
        this.values.put("messages.world.unloading.finished", this.fileConfiguration.getString("messages.world.unloading.finished"));
        this.values.put("messages.world.unloading.chunk-starting", this.fileConfiguration.getString("messages.world.unloading.chunk-starting"));
        this.values.put("messages.world.unloading.chunk-finished", this.fileConfiguration.getString("messages.world.unloading.chunk-finished"));
        this.values.put("messages.world.unloading.chunk-teleport", this.fileConfiguration.getString("messages.world.unloading.chunk-teleport"));
        this.values.put("messages.world.loading.starting", this.fileConfiguration.getString("messages.world.loading.starting"));
        this.values.put("messages.world.loading.finished", this.fileConfiguration.getString("messages.world.loading.finished"));
        this.values.put("messages.world.loading.already-loaded", this.fileConfiguration.getString("messages.world.loading.already-loaded"));
        this.values.put("messages.world.loading.not-loaded", this.fileConfiguration.getString("messages.world.loading.not-loaded"));
        this.values.put("messages.world.loading.not-registered", this.fileConfiguration.getString("messages.world.loading.not-registered"));
        this.values.put("messages.world.options.updating", this.fileConfiguration.getString("messages.world.options.updating"));
        this.values.put("messages.world.options.value-wrong", this.fileConfiguration.getString("messages.world.options.value-wrong"));
        this.values.put("messages.world.options.not-available", this.fileConfiguration.getString("messages.world.options.not-available"));
        this.values.put("messages.world.teleport.message", this.fileConfiguration.getString("messages.world.teleport.message"));
        this.values.put("messages.world.teleport.component-message", this.fileConfiguration.getString("messages.world.teleport.component-message"));
        this.values.put("messages.world.teleport.component-hover-text", this.fileConfiguration.getString("messages.world.teleport.component-hover-text"));
        this.values.put("messages.world.teleport.target-already-in-world", this.fileConfiguration.getString("messages.world.teleport.target-already-in-world"));
        this.values.put("messages.world.teleport.sender-already-in-world", this.fileConfiguration.getString("messages.world.teleport.sender-already-in-world"));
        this.values.put("messages.world.info", this.fileConfiguration.getStringList("messages.world.info"));
        this.values.put("messages.world.help", this.fileConfiguration.getStringList("messages.world.help"));
    }

    @Override
    public String getPrefix() {
        return (String)super.getValueSafe("prefix");
    }

    @Override
    public String getNoPermissionMessage() {
        return super.getStringSafe("no-permission").replaceAll("%prefix%", this.getPrefix());
    }

    @Override
    public String getPlayerNotFoundMessage() {
        return super.getStringSafe("player-not-found").replaceAll("%prefix%", this.getPrefix());
    }

    public String getOnlyPlayerCommandMessage() {
        return super.getStringSafe("only-player-command").replaceAll("%prefix%", this.getPrefix());
    }

    public List<String> getStringList(String key) {
        return (List)this.values.getValue(key);
    }

    public List<String> getAutoLoadableWorlds() {
        return this.fileConfiguration.getStringList("auto-load");
    }

    public String getUsage() {
        return super.getStringSafe("usage").replaceAll("%prefix%", this.getPrefix());
    }

    public String getDefaultWorldName() {
        return this.values.getString("defaults.world");
    }

    public String getWorldMessage(String key) {
        return this.getMessage("world." + key);
    }

    public String getMessage(String key) {
        return super.getStringSafe("messages." + key).replaceAll("%prefix%", this.getPrefix());
    }

    public ParsedMap<String, Object> getValues() {
        return this.values;
    }
}

