/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.java.map;

import java.util.HashMap;
import java.util.UUID;

public class ParsedMap<K, V>
extends HashMap<K, V> {
    public ParsedMap() {
    }

    public ParsedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public <V> V getValue(String key) {
        return this.get(key);
    }

    public <V> V getValue(String key, V defaultValue) {
        return this.get(key) == null ? defaultValue : this.get(key);
    }

    public String getString(K key) {
        return super.get(key).toString();
    }

    public String getString(K key, String defaultValue) {
        return super.get(key).toString() == null ? defaultValue : super.get(key).toString();
    }

    public byte getByte(K key) {
        return Byte.parseByte(this.getString(key));
    }

    public byte getByte(K key, byte defaultValue) {
        return this.getString(key) == null ? defaultValue : Byte.parseByte(this.getString(key));
    }

    public short getShort(K key) {
        return Short.parseShort(this.getString(key));
    }

    public short getShort(K key, short defaultValue) {
        return this.getString(key) == null ? defaultValue : Short.parseShort(this.getString(key));
    }

    public int getInteger(K key, int defaultValue) {
        return this.getString(key) == null ? defaultValue : Integer.parseInt(this.getString(key));
    }

    public int getInteger(K key) {
        return Integer.parseInt(this.getString(key));
    }

    public long getLong(K key) {
        return Long.parseLong(this.getString(key));
    }

    public long getLong(K key, long defaultValue) {
        return this.getString(key) == null ? defaultValue : Long.parseLong(this.getString(key));
    }

    public float getFloat(K key) {
        return Float.parseFloat(this.getString(key));
    }

    public float getFloat(K key, float defaultValue) {
        return this.getString(key) == null ? defaultValue : Float.parseFloat(this.getString(key));
    }

    public double getDouble(K key) {
        return Double.parseDouble(this.getString(key));
    }

    public double getDouble(K key, double defaultValue) {
        return this.getString(key) == null ? defaultValue : Double.parseDouble(this.getString(key));
    }

    public boolean getBoolean(K key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public boolean getBoolean(K key, boolean defaultValue) {
        return this.getString(key) == null ? defaultValue : Boolean.parseBoolean(this.getString(key));
    }

    public UUID getUUID(K key) {
        return UUID.fromString(this.getString(key));
    }
}

