/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.world.cuboid;

import com.dev7ex.common.bukkit.world.cuboid.CuboidDirection;
import com.dev7ex.common.bukkit.world.cuboid.CuboidIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Cuboid
implements Cloneable,
Iterable<Block> {
    private Location firstLocation;
    private Location secondLocation;
    private final String worldName;
    private final int x1;
    private final int y1;
    private final int z1;
    private final int x2;
    private final int y2;
    private final int z2;

    public Cuboid(Location firstLocation, Location secondLocation) {
        this.firstLocation = firstLocation;
        this.secondLocation = secondLocation;
        this.worldName = firstLocation.getWorld().getName();
        this.x1 = Math.min(this.firstLocation.getBlockX(), this.secondLocation.getBlockX());
        this.y1 = Math.min(this.firstLocation.getBlockY(), this.secondLocation.getBlockY());
        this.z1 = Math.min(this.firstLocation.getBlockZ(), this.secondLocation.getBlockZ());
        this.x2 = Math.max(this.firstLocation.getBlockX(), this.secondLocation.getBlockX());
        this.y2 = Math.max(this.firstLocation.getBlockY(), this.secondLocation.getBlockY());
        this.z2 = Math.max(this.firstLocation.getBlockZ(), this.secondLocation.getBlockZ());
    }

    public Cuboid(Location firstLocation) {
        this(firstLocation, firstLocation);
    }

    public Cuboid(Cuboid otherRegion) {
        this(otherRegion.getWorld().getName(), otherRegion.x1, otherRegion.y1, otherRegion.z1, otherRegion.x2, otherRegion.y2, otherRegion.z2);
    }

    public Cuboid(Map<String, Object> map) {
        this.worldName = (String)map.get("worldName");
        this.x1 = (Integer)map.get("x1");
        this.x2 = (Integer)map.get("x2");
        this.y1 = (Integer)map.get("y1");
        this.y2 = (Integer)map.get("y2");
        this.z1 = (Integer)map.get("z1");
        this.z2 = (Integer)map.get("z2");
    }

    public Map<String, Object> serialize() {
        HashMap map = Maps.newHashMap();
        map.put("worldName", this.worldName);
        map.put("x1", this.x1);
        map.put("y1", this.y1);
        map.put("z1", this.z1);
        map.put("x2", this.x2);
        map.put("y2", this.y2);
        map.put("z2", this.z2);
        return map;
    }

    public Cuboid(String worldName, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.worldName = worldName;
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public final List<Chunk> getChunks() {
        ArrayList chunks = Lists.newArrayList();
        World world = this.getWorld();
        int x1 = this.getLowerX() & 0xFFFFFFF0;
        int x2 = this.getUpperX() & 0xFFFFFFF0;
        int z1 = this.getLowerZ() & 0xFFFFFFF0;
        int z2 = this.getUpperZ() & 0xFFFFFFF0;
        for (int x = x1; x <= x2; x += 16) {
            for (int z = z1; z <= z2; z += 16) {
                chunks.add(world.getChunkAt(x >> 4, z >> 4));
            }
        }
        return chunks;
    }

    public final List<Block> getBlocks() {
        Iterator<Block> blockIterator = this.iterator();
        ArrayList blockList = Lists.newArrayList();
        while (blockIterator.hasNext()) {
            blockList.add(blockIterator.next());
        }
        return blockList;
    }

    public final Location getCenter() {
        int x1 = this.getUpperX() + 1;
        int y1 = this.getUpperY() + 1;
        int z1 = this.getUpperZ() + 1;
        return new Location(this.getWorld(), (double)this.getLowerX() + (double)(x1 - this.getLowerX()) / 2.0, (double)this.getLowerY() + (double)(y1 - this.getLowerY()) / 2.0, (double)this.getLowerZ() + (double)(z1 - this.getLowerZ()) / 2.0);
    }

    public final Cuboid getFace(CuboidDirection regionDirection) {
        switch (regionDirection) {
            case Down: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y1, this.z2);
            }
            case Up: {
                return new Cuboid(this.worldName, this.x1, this.y2, this.z1, this.x2, this.y2, this.z2);
            }
            case North: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x1, this.y2, this.z2);
            }
            case South: {
                return new Cuboid(this.worldName, this.x2, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case East: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z1);
            }
            case West: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z2, this.x2, this.y2, this.z2);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + regionDirection);
    }

    public final Cuboid expand(CuboidDirection regionDirection, int amount) {
        switch (regionDirection) {
            case North: {
                return new Cuboid(this.worldName, this.x1 - amount, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case South: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2 + amount, this.y2, this.z2);
            }
            case East: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1 - amount, this.x2, this.y2, this.z2);
            }
            case West: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2 + amount);
            }
            case Down: {
                return new Cuboid(this.worldName, this.x1, this.y1 - amount, this.z1, this.x2, this.y2, this.z2);
            }
            case Up: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2 + amount, this.z2);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + regionDirection);
    }

    public final boolean isOnlyContaining(Material material) {
        for (Block b : this) {
            if (b.getType() == material) continue;
            return false;
        }
        return true;
    }

    public final Block getRelativeBlock(World world, int x, int y, int z) {
        return this.getWorld().getBlockAt(this.x1 + x, this.y1 + y, this.z1 + z);
    }

    @Override
    public final Iterator<Block> iterator() {
        return new CuboidIterator(Bukkit.getWorld((String)this.worldName), this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public final boolean contains(int x, int y, int z) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2 && z >= this.z1 && z <= this.z2;
    }

    public Cuboid getBoundingCuboid(Cuboid other) {
        if (other == null) {
            return this;
        }
        int xMin = Math.min(this.getLowerX(), other.getLowerX());
        int yMin = Math.min(this.getLowerY(), other.getLowerY());
        int zMin = Math.min(this.getLowerZ(), other.getLowerZ());
        int xMax = Math.max(this.getUpperX(), other.getUpperX());
        int yMax = Math.max(this.getUpperY(), other.getUpperY());
        int zMax = Math.max(this.getUpperZ(), other.getUpperZ());
        return new Cuboid(this.worldName, xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public final Block[] getCorners() {
        Block[] res = new Block[8];
        World world = this.getWorld();
        res[0] = world.getBlockAt(this.x1, this.y1, this.z1);
        res[1] = world.getBlockAt(this.x1, this.y1, this.z2);
        res[2] = world.getBlockAt(this.x1, this.y2, this.z1);
        res[3] = world.getBlockAt(this.x1, this.y2, this.z2);
        res[4] = world.getBlockAt(this.x2, this.y1, this.z1);
        res[5] = world.getBlockAt(this.x2, this.y1, this.z2);
        res[6] = world.getBlockAt(this.x2, this.y2, this.z1);
        res[7] = world.getBlockAt(this.x2, this.y2, this.z2);
        return res;
    }

    public final boolean contains(Block block) {
        return this.contains(block.getLocation());
    }

    public final boolean contains(Location location) {
        if (!this.worldName.equals(location.getWorld().getName())) {
            return false;
        }
        return this.contains(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public final int getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public final World getWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public final int getSizeX() {
        return this.x2 - this.x1 + 1;
    }

    public final int getSizeY() {
        return this.y2 - this.y1 + 1;
    }

    public final int getSizeZ() {
        return this.z2 - this.z1 + 1;
    }

    public int getLowerX() {
        return this.x1;
    }

    public final int getLowerY() {
        return this.y1;
    }

    public final int getLowerZ() {
        return this.z1;
    }

    public final int getUpperX() {
        return this.x2;
    }

    public final int getUpperY() {
        return this.y2;
    }

    public final int getUpperZ() {
        return this.z2;
    }
}

