/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.plugin.service;

import com.dev7ex.common.bukkit.plugin.service.PluginService;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class ServiceManager {
    private final Deque<PluginService> serviceDeque = new ArrayDeque<PluginService>();
    private final Map<String, PluginService> pluginServices = new HashMap<String, PluginService>();
    private final Plugin plugin;

    public ServiceManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void registerService(PluginService pluginService) {
        this.serviceDeque.add(pluginService);
    }

    public void unregisterService(PluginService pluginService) {
        this.pluginServices.remove(pluginService.getName());
    }

    public void onEnable() {
        while (!this.serviceDeque.isEmpty()) {
            this.serviceDeque.pollFirst().onEnable();
        }
    }

    public void onDisable() {
        this.pluginServices.values().forEach(PluginService::onDisable);
    }
}

