/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.plugin.configuration;

import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.java.map.ParsedMap;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class PluginConfiguration {
    protected final FileConfiguration fileConfiguration;
    protected ParsedMap<String, Object> values = new ParsedMap(100);

    public PluginConfiguration(BukkitPlugin bukkitPlugin) {
        this.fileConfiguration = bukkitPlugin.getConfig();
        bukkitPlugin.setDataFolderUsed(true);
        bukkitPlugin.setDefaultConfigUsed(true);
    }

    public <V> V getValueSafe(String key) {
        if (!this.values.containsKey(key)) {
            return (V)this.values.put(key, this.fileConfiguration.get(key));
        }
        return this.values.get(key);
    }

    public boolean getBooleanSafe(String key) {
        if (!this.values.containsKey(key)) {
            return Boolean.parseBoolean(String.valueOf(this.values.put(key, this.fileConfiguration.getBoolean(key))));
        }
        return this.values.getBoolean(key);
    }

    public String getStringSafe(String key) {
        if (!this.values.containsKey(key)) {
            return String.valueOf(this.values.put(key, this.fileConfiguration.getString(key)));
        }
        return this.values.getString(key);
    }

    @Deprecated
    public final String getMessageSafe(String key) {
        if (this.values.containsKey(key)) {
            return this.values.getString(key);
        }
        return String.valueOf(this.values.put(key, this.fileConfiguration.getString(key)));
    }

    public abstract void load();

    public abstract String getPrefix();

    public abstract String getNoPermissionMessage();

    public abstract String getPlayerNotFoundMessage();
}

