/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.plugin;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandExecutor;
import com.dev7ex.common.bukkit.plugin.service.PluginService;
import com.dev7ex.common.bukkit.plugin.service.ServiceManager;
import java.util.function.Predicate;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimplePlugin
extends JavaPlugin {
    private final ServiceManager serviceManager = new ServiceManager((Plugin)this);

    public void onEnable() {
        this.serviceManager.onEnable();
        super.onEnable();
    }

    public void onDisable() {
        this.serviceManager.onDisable();
        super.onDisable();
    }

    public Listener registerListener(Listener listener) {
        super.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        return listener;
    }

    public Listener registerListenerIf(Listener listener, Predicate<Boolean> predicate) {
        if (predicate.test(true)) {
            return this.registerListener(listener);
        }
        return listener;
    }

    public void registerCommand(BukkitCommand bukkitCommand) {
        PluginCommand pluginCommand = super.getCommand(bukkitCommand.getName());
        pluginCommand.setExecutor((CommandExecutor)new BukkitCommandExecutor(bukkitCommand));
        if (!(bukkitCommand instanceof TabCompleter)) {
            return;
        }
        pluginCommand.setTabCompleter((TabCompleter)bukkitCommand);
    }

    public PluginCommand registerCommand(String command) {
        return super.getServer().getPluginCommand(command);
    }

    public void registerService(PluginService pluginService) {
        this.serviceManager.registerService(pluginService);
        pluginService.getListener().forEach(this::registerListener);
    }

    public void registerServiceIf(PluginService pluginService, Predicate<Boolean> predicate) {
        if (predicate.test(false)) {
            return;
        }
        this.serviceManager.registerService(pluginService);
    }
}

