/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.plugin;

import com.dev7ex.common.bukkit.plugin.SimplePlugin;
import com.dev7ex.common.bukkit.plugin.configuration.PluginConfiguration;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class BukkitPlugin
extends SimplePlugin {
    private final Map<String, File> subFolders = Maps.newHashMap();
    private boolean defaultConfigUsed = false;
    private boolean dataFolderUsed = false;

    public void onLoad() {
        if (this.dataFolderUsed && !super.getDataFolder().exists()) {
            super.getDataFolder().mkdirs();
        }
        if (this.defaultConfigUsed && super.getDataFolder().exists()) {
            super.saveDefaultConfig();
            this.subFolders.values().forEach(File::mkdirs);
        }
        this.getConfiguration().load();
    }

    @Override
    public void onEnable() {
        this.registerCommands();
        this.registerListeners();
        this.registerServices();
        super.onEnable();
    }

    @Override
    public void onDisable() {
        super.onDisable();
    }

    public void addSubFolder(String folderName) {
        this.subFolders.put(folderName, new File(this.getDataFolder().getPath() + File.separator + folderName));
    }

    public void removeSubFolder(String folderName) {
        File subFolder = this.getSubFolder(folderName);
        if (!subFolder.exists()) {
            return;
        }
        FileUtils.deleteDirectory(subFolder);
    }

    public File getSubFolder(String folderName) {
        return this.subFolders.get(folderName);
    }

    public abstract PluginConfiguration getConfiguration();

    public void registerServices() {
    }

    public void registerCommands() {
    }

    public void registerListeners() {
    }

    public Map<String, File> getSubFolders() {
        return this.subFolders;
    }

    public boolean isDefaultConfigUsed() {
        return this.defaultConfigUsed;
    }

    public boolean isDataFolderUsed() {
        return this.dataFolderUsed;
    }

    public void setDefaultConfigUsed(boolean defaultConfigUsed) {
        this.defaultConfigUsed = defaultConfigUsed;
    }

    public void setDataFolderUsed(boolean dataFolderUsed) {
        this.dataFolderUsed = dataFolderUsed;
    }
}

