/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.location;

import com.dev7ex.common.bukkit.configuration.SimpleConfiguration;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class LocationConfiguration
extends SimpleConfiguration {
    public LocationConfiguration(Plugin plugin, String fileName) {
        super(plugin, fileName);
    }

    public void setLocation(String name, Location location) {
        this.yamlConfiguration.set("locations." + name + ".world", (Object)location.getWorld().getName());
        this.yamlConfiguration.set("locations." + name + ".x", (Object)location.getX());
        this.yamlConfiguration.set("locations." + name + ".y", (Object)location.getY());
        this.yamlConfiguration.set("locations." + name + ".z", (Object)location.getZ());
        this.yamlConfiguration.set("locations." + name + ".pitch", (Object)Float.valueOf(location.getPitch()));
        this.yamlConfiguration.set("locations." + name + ".yaw", (Object)Float.valueOf(location.getYaw()));
        super.saveFile();
    }

    public Location getLocation(String name) {
        String world = this.yamlConfiguration.getString("locations." + name + ".world");
        double x = this.yamlConfiguration.getDouble("locations." + name + ".x");
        double y = this.yamlConfiguration.getDouble("locations." + name + ".y");
        double z = this.yamlConfiguration.getDouble("locations." + name + ".z");
        float pitch = (float)this.yamlConfiguration.getDouble("locations." + name + ".pitch");
        float yaw = (float)this.yamlConfiguration.getDouble("locations." + name + ".yaw");
        return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }

    public boolean locationExists(String name) {
        return this.yamlConfiguration.contains(name);
    }

    public void deleteLocation(String name) {
        this.yamlConfiguration.set(name, null);
        super.saveFile();
    }

    public Map<String, Location> getLocationsAsMap() {
        HashMap locations = Maps.newHashMap();
        for (String location : this.yamlConfiguration.getKeys(false)) {
            locations.put(location, this.getLocation(location));
        }
        return locations;
    }

    @Deprecated
    public Set<Location> getLocations() {
        HashSet<Location> locations = new HashSet<Location>();
        for (String location : this.yamlConfiguration.getKeys(false)) {
            locations.add(this.getLocation(location));
        }
        return locations;
    }
}

