/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.location;

import org.bukkit.Location;
import org.bukkit.World;

public class LocationBuilder {
    private final World world;
    private double x;
    private double y;
    private double z;
    private float pitch = 0.0f;
    private float yaw = 0.0f;

    public LocationBuilder(World world) {
        this.world = world;
    }

    public LocationBuilder setX(double x) {
        this.x = x;
        return this;
    }

    public LocationBuilder setY(double y) {
        this.y = y;
        return this;
    }

    public LocationBuilder setZ(double z) {
        this.z = z;
        return this;
    }

    public LocationBuilder setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public LocationBuilder setYaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    public Location build() {
        return new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public World getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }
}

