/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.inventory.item;

import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemStackBuilder {
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;

    public ItemStackBuilder(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemMeta = itemStack.getItemMeta();
    }

    public ItemStackBuilder(Material material) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemStackBuilder(Material material, int amount) {
        this.itemStack = new ItemStack(material, amount);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemStackBuilder setDisplayName(String name) {
        this.itemMeta.setDisplayName(name);
        return this;
    }

    public ItemStackBuilder setLore(String ... lore) {
        this.itemMeta.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemStackBuilder setUnbreakable(boolean unbreakable) {
        this.itemMeta.setUnbreakable(unbreakable);
        return this;
    }

    public ItemStackBuilder addEnchantment(Enchantment enchantment, int level) {
        this.itemMeta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemStackBuilder setAmount(int amount) {
        if (amount > 64) {
            throw new IllegalArgumentException("The amount cannot be greater than 64.");
        }
        this.itemStack.setAmount(amount);
        return this;
    }

    public final ItemStackBuilder setCustomModelData(int modelData) {
        this.itemMeta.setCustomModelData(Integer.valueOf(modelData));
        return this;
    }

    public final ItemStack build() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }
}

