/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.configuration;

import com.dev7ex.common.bukkit.configuration.ConfigurationProperties;
import com.dev7ex.common.java.configuration.ConfigurationSerializable;
import com.dev7ex.common.java.io.FileExtension;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public abstract class ObjectConfiguration<T extends ConfigurationSerializable> {
    protected T serializableObject;
    protected Plugin plugin;
    protected File configurationFile;
    protected YamlConfiguration yamlConfiguration;

    public ObjectConfiguration(Plugin plugin, T serializableObject) {
        if (!this.getClass().isAnnotationPresent(ConfigurationProperties.class)) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " must have Configuration Annotation");
        }
        this.configurationFile = new File(plugin.getDataFolder() + File.separator + this.getFileName() + this.getFileExtension().getExtension());
        this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
        this.plugin = plugin;
        this.serializableObject = serializableObject;
    }

    public void serialize() {
        this.serializableObject.serialize().keySet().forEach(key -> this.yamlConfiguration.set(key, this.serializableObject.serialize().get(key)));
        this.saveFile();
    }

    public void saveFile() {
        try {
            this.yamlConfiguration.save(this.configurationFile);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public final String getFileName() {
        return this.getClass().getAnnotation(ConfigurationProperties.class).fileName();
    }

    public final FileExtension getFileExtension() {
        return this.getClass().getAnnotation(ConfigurationProperties.class).fileExtension();
    }

    public T getSerializableObject() {
        return this.serializableObject;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public YamlConfiguration getYamlConfiguration() {
        return this.yamlConfiguration;
    }

    public void setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
    }
}

