/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.configuration;

import com.dev7ex.common.bukkit.configuration.ConfigurationProperties;
import com.dev7ex.common.java.io.FileExtension;
import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public abstract class ConfigurationBase {
    protected final File configurationFile;
    protected final YamlConfiguration yamlConfiguration;

    public ConfigurationBase(Plugin plugin) {
        if (!this.getClass().isAnnotationPresent(ConfigurationProperties.class)) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " must have Configuration Annotation");
        }
        this.configurationFile = new File(plugin.getDataFolder() + File.separator + this.getFileName() + this.getFileExtension().getExtension());
        this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
        if (!this.configurationFile.exists()) {
            this.configurationFile.createNewFile();
        }
    }

    public void saveFile() {
        this.yamlConfiguration.save(this.configurationFile);
    }

    public final String getFileName() {
        return this.getClass().getAnnotation(ConfigurationProperties.class).fileName();
    }

    public final FileExtension getFileExtension() {
        return this.getClass().getAnnotation(ConfigurationProperties.class).fileExtension();
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public YamlConfiguration getYamlConfiguration() {
        return this.yamlConfiguration;
    }
}

