/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.command;

import com.dev7ex.common.bukkit.command.CommandProperties;
import com.dev7ex.common.bukkit.command.SubCommandProvider;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.bukkit.plugin.configuration.PluginConfiguration;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;

public abstract class BukkitCommand
implements SubCommandProvider {
    private final BukkitPlugin plugin;
    private final Map<String, BukkitCommand> subCommands = Maps.newHashMap();
    private String usage;
    private final List<String> aliases = Lists.newArrayList();

    public BukkitCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public void registerSubCommand(BukkitCommand bukkitCommand) {
        if (bukkitCommand.getAliases() != null && !bukkitCommand.getAliases().isEmpty()) {
            bukkitCommand.getAliases().forEach(aliases -> this.subCommands.put((String)aliases, bukkitCommand));
        }
        this.subCommands.put(bukkitCommand.getName(), bukkitCommand);
    }

    @Override
    public Map<String, BukkitCommand> getSubCommands() {
        return this.subCommands;
    }

    public BukkitCommand getSubCommand(String name) {
        return this.subCommands.get(name);
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getName() {
        return this.getClass().getAnnotation(CommandProperties.class).name();
    }

    public String getPermission() {
        return this.getClass().getAnnotation(CommandProperties.class).permission();
    }

    public PluginConfiguration getConfiguration() {
        return this.plugin.getConfiguration();
    }

    public String getPrefix() {
        return this.plugin.getConfiguration().getPrefix();
    }

    public String getNoPermissionMessage() {
        return this.plugin.getConfiguration().getNoPermissionMessage();
    }

    public String getPlayerNotFoundMessage() {
        return this.plugin.getConfiguration().getPlayerNotFoundMessage();
    }

    public List<String> getAliases() {
        return this.aliases;
    }
}

