/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.core.asm.utils;

import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleNode;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParticleRegistry {
    private List<Map<String, ParticleNode>> particleMaps = new ArrayList<Map<String, ParticleNode>>();

    public ParticleRegistry() {
        ParticleVersion[] versions = ParticleVersion.values();
        for (int i = 0; i < versions.length; ++i) {
            this.particleMaps.add(new HashMap());
        }
        this.fillMap_1_7();
        this.fillMap_1_8();
        this.fillMap_1_13();
    }

    public String find(ParticleVersion from, String name, ParticleVersion to) {
        ParticleNode node = this.particleMaps.get(from.ordinal()).get(name);
        if (node == null) {
            return null;
        }
        ParticleNode resolvedNode = node.find(to);
        if (resolvedNode == null || resolvedNode.isRemoved()) {
            return null;
        }
        return resolvedNode.getName();
    }

    private void fillMap_1_7() {
        ParticleVersion v = ParticleVersion.V1_7;
        this.put(new ParticleNode(v, "explode"));
        this.put(new ParticleNode(v, "largeexplode"));
        this.put(new ParticleNode(v, "hugeexplosion"));
        this.put(new ParticleNode(v, "fireworksSpark"));
        this.put(new ParticleNode(v, "bubble"));
        this.put(new ParticleNode(v, "splash"));
        this.put(new ParticleNode(v, "wake"));
        this.put(new ParticleNode(v, "suspended"));
        this.put(new ParticleNode(v, "depthsuspend"));
        this.put(new ParticleNode(v, "crit"));
        this.put(new ParticleNode(v, "magicCrit"));
        this.put(new ParticleNode(v, "smoke"));
        this.put(new ParticleNode(v, "largesmoke"));
        this.put(new ParticleNode(v, "spell"));
        this.put(new ParticleNode(v, "instantSpell"));
        this.put(new ParticleNode(v, "mobSpell"));
        this.put(new ParticleNode(v, "mobSpellAmbient"));
        this.put(new ParticleNode(v, "witchMagic"));
        this.put(new ParticleNode(v, "dripWater"));
        this.put(new ParticleNode(v, "dripLava"));
        this.put(new ParticleNode(v, "angryVillager"));
        this.put(new ParticleNode(v, "happyVillager"));
        this.put(new ParticleNode(v, "townaura"));
        this.put(new ParticleNode(v, "note"));
        this.put(new ParticleNode(v, "portal"));
        this.put(new ParticleNode(v, "enchantmenttable"));
        this.put(new ParticleNode(v, "flame"));
        this.put(new ParticleNode(v, "lava"));
        this.put(new ParticleNode(v, "footstep"));
        this.put(new ParticleNode(v, "cloud"));
        this.put(new ParticleNode(v, "reddust"));
        this.put(new ParticleNode(v, "snowballpoof"));
        this.put(new ParticleNode(v, "snowshovel"));
        this.put(new ParticleNode(v, "slime"));
        this.put(new ParticleNode(v, "heart"));
        this.put(new ParticleNode(v, "iconcrack_"));
        this.put(new ParticleNode(v, "blockcrack_"));
        this.put(new ParticleNode(v, "blockdust_"));
    }

    private void fillMap_1_8() {
        Map<String, ParticleNode> particleMap = this.particleMaps.get(ParticleVersion.V1_7.ordinal());
        this.put(particleMap.get("explode").follow("EXPLOSION_NORMAL"));
        this.put(particleMap.get("largeexplode").follow("EXPLOSION_LARGE"));
        this.put(particleMap.get("hugeexplosion").follow("EXPLOSION_HUGE"));
        this.put(particleMap.get("fireworksSpark").follow("FIREWORKS_SPARK"));
        this.put(particleMap.get("bubble").follow("WATER_BUBBLE"));
        this.put(particleMap.get("splash").follow("WATER_SPLASH"));
        this.put(particleMap.get("wake").follow("WATER_WAKE"));
        this.put(particleMap.get("suspended").follow("SUSPENDED"));
        this.put(particleMap.get("depthsuspend").follow("SUSPENDED_DEPTH"));
        this.put(particleMap.get("crit").follow("CRIT"));
        this.put(particleMap.get("magicCrit").follow("CRIT_MAGIC"));
        this.put(particleMap.get("smoke").follow("SMOKE_NORMAL"));
        this.put(particleMap.get("largesmoke").follow("SMOKE_LARGE"));
        this.put(particleMap.get("spell").follow("SPELL"));
        this.put(particleMap.get("instantSpell").follow("SPELL_INSTANT"));
        this.put(particleMap.get("mobSpell").follow("SPELL_MOB"));
        this.put(particleMap.get("mobSpellAmbient").follow("SPELL_MOB_AMBIENT"));
        this.put(particleMap.get("witchMagic").follow("SPELL_WITCH"));
        this.put(particleMap.get("dripWater").follow("DRIP_WATER"));
        this.put(particleMap.get("dripLava").follow("DRIP_LAVA"));
        this.put(particleMap.get("angryVillager").follow("VILLAGER_ANGRY"));
        this.put(particleMap.get("happyVillager").follow("VILLAGER_HAPPY"));
        this.put(particleMap.get("townaura").follow("TOWN_AURA"));
        this.put(particleMap.get("note").follow("NOTE"));
        this.put(particleMap.get("portal").follow("PORTAL"));
        this.put(particleMap.get("enchantmenttable").follow("ENCHANTMENT_TABLE"));
        this.put(particleMap.get("flame").follow("FLAME"));
        this.put(particleMap.get("lava").follow("LAVA"));
        this.put(particleMap.get("footstep").follow("FOOTSTEP"));
        this.put(particleMap.get("cloud").follow("CLOUD"));
        this.put(particleMap.get("reddust").follow("REDSTONE"));
        this.put(particleMap.get("snowballpoof").follow("SNOWBALL"));
        this.put(particleMap.get("snowshovel").follow("SNOW_SHOVEL"));
        this.put(particleMap.get("slime").follow("SLIME"));
        this.put(particleMap.get("heart").follow("HEART"));
        this.put(particleMap.get("iconcrack_").follow("ITEM_CRACK"));
        this.put(particleMap.get("blockcrack_").follow("BLOCK_CRACK"));
        this.put(particleMap.get("blockdust_").follow("BLOCK_DUST"));
        ParticleVersion v = ParticleVersion.V1_8;
        this.put(new ParticleNode(v, "BARRIER"));
        this.put(new ParticleNode(v, "WATER_DROP"));
        this.put(new ParticleNode(v, "ITEM_TAKE"));
        this.put(new ParticleNode(v, "MOB_APPEARANCE"));
        this.put(new ParticleNode(v, "DRAGON_BREATH"));
        this.put(new ParticleNode(v, "END_ROD"));
        this.put(new ParticleNode(v, "DAMAGE_INDICATOR"));
        this.put(new ParticleNode(v, "SWEEP_ATTACK"));
        this.put(new ParticleNode(v, "FALLING_DUST"));
        this.put(new ParticleNode(v, "TOTEM"));
        this.put(new ParticleNode(v, "SPIT"));
    }

    private void fillMap_1_13() {
        Map<String, ParticleNode> particleMap = this.particleMaps.get(ParticleVersion.V1_8.ordinal());
        ParticleNode poofNode = particleMap.get("EXPLOSION_NORMAL").follow("POOF");
        ParticleNode blockNode = particleMap.get("BLOCK_CRACK").follow("BLOCK");
        this.put(particleMap.get("EXPLOSION_NORMAL").follow(poofNode));
        this.put(particleMap.get("EXPLOSION_LARGE").follow("EXPLOSION"));
        this.put(particleMap.get("EXPLOSION_HUGE").follow("EXPLOSION_EMITTER"));
        this.put(particleMap.get("FIREWORKS_SPARK").follow("FIREWORK"));
        this.put(particleMap.get("WATER_BUBBLE").follow("BUBBLE"));
        this.put(particleMap.get("WATER_SPLASH").follow("SPLASH"));
        this.put(particleMap.get("WATER_WAKE").follow("FISHING"));
        this.put(particleMap.get("SUSPENDED").follow("UNDERWATER"));
        this.put(particleMap.get("SUSPENDED_DEPTH").followRemoved());
        this.put(particleMap.get("CRIT").follow());
        this.put(particleMap.get("CRIT_MAGIC").follow("ENCHANTED_HIT"));
        this.put(particleMap.get("SMOKE_NORMAL").follow("SMOKE"));
        this.put(particleMap.get("SMOKE_LARGE").follow("LARGE_SMOKE"));
        this.put(particleMap.get("SPELL").follow("EFFECT"));
        this.put(particleMap.get("SPELL_INSTANT").follow("INSTANT_EFFECT"));
        this.put(particleMap.get("SPELL_MOB").follow("ENTITY_EFFECT"));
        this.put(particleMap.get("SPELL_MOB_AMBIENT").follow("AMBIENT_ENTITY_EFFECT"));
        this.put(particleMap.get("SPELL_WITCH").follow("WITCH"));
        this.put(particleMap.get("DRIP_WATER").follow("DRIPPING_WATER"));
        this.put(particleMap.get("DRIP_LAVA").follow("DRIPPING_LAVA"));
        this.put(particleMap.get("VILLAGER_ANGRY").follow("ANGRY_VILLAGER"));
        this.put(particleMap.get("VILLAGER_HAPPY").follow("HAPPY_VILLAGER"));
        this.put(particleMap.get("TOWN_AURA").follow("MYCELIUM"));
        this.put(particleMap.get("NOTE").follow());
        this.put(particleMap.get("PORTAL").follow());
        this.put(particleMap.get("ENCHANTMENT_TABLE").follow("ENCHANT"));
        this.put(particleMap.get("FLAME").follow());
        this.put(particleMap.get("LAVA").follow());
        this.put(particleMap.get("FOOTSTEP").followRemoved());
        this.put(particleMap.get("CLOUD").follow());
        this.put(particleMap.get("REDSTONE").followForward("DUST"));
        this.put(particleMap.get("SNOWBALL").follow("ITEM_SNOWBALL"));
        this.put(particleMap.get("SNOW_SHOVEL").follow(poofNode));
        this.put(particleMap.get("SLIME").follow("ITEM_SLIME"));
        this.put(particleMap.get("HEART").follow());
        this.put(particleMap.get("BARRIER").follow());
        this.put(particleMap.get("ITEM_CRACK").follow("ITEM"));
        this.put(particleMap.get("BLOCK_CRACK").follow(blockNode));
        this.put(particleMap.get("BLOCK_DUST").follow(blockNode));
        this.put(particleMap.get("WATER_DROP").follow("RAIN"));
        this.put(particleMap.get("ITEM_TAKE").followRemoved());
        this.put(particleMap.get("MOB_APPEARANCE").follow("ELDER_GUARDIAN"));
        this.put(particleMap.get("DRAGON_BREATH").follow());
        this.put(particleMap.get("END_ROD").follow());
        this.put(particleMap.get("DAMAGE_INDICATOR").follow());
        this.put(particleMap.get("SWEEP_ATTACK").follow());
        this.put(particleMap.get("FALLING_DUST").follow());
        this.put(particleMap.get("TOTEM").follow("TOTEM_OF_UNDYING"));
        this.put(particleMap.get("SPIT").follow());
        ParticleVersion v = ParticleVersion.V1_13;
        this.put(new ParticleNode(v, "BUBBLE_COLUMN_UP"));
        this.put(new ParticleNode(v, "BUBBLE_POP"));
        this.put(new ParticleNode(v, "CURRENT_DOWN"));
        this.put(new ParticleNode(v, "SQUID_INK"));
        this.put(new ParticleNode(v, "NAUTILUS"));
        this.put(new ParticleNode(v, "DOLPHIN"));
        this.put(new ParticleNode(v, "SNEEZE"));
        this.put(new ParticleNode(v, "CAMPFIRE_COSY_SMOKE"));
        this.put(new ParticleNode(v, "CAMPFIRE_SIGNAL_SMOKE"));
        this.put(new ParticleNode(v, "COMPOSTER"));
        this.put(new ParticleNode(v, "FLASH"));
        this.put(new ParticleNode(v, "DRIPPING_HONEY"));
        this.put(new ParticleNode(v, "FALLING_NECTAR"));
        this.put(new ParticleNode(v, "FALLING_HONEY"));
        this.put(new ParticleNode(v, "FALLING_LAVA"));
        this.put(new ParticleNode(v, "FALLING_WATER"));
        this.put(new ParticleNode(v, "LANDING_HONEY"));
        this.put(new ParticleNode(v, "LANDING_LAVA"));
        this.put(new ParticleNode(v, "SOUL_FIRE_FLAME"));
        this.put(new ParticleNode(v, "SOUL"));
        this.put(new ParticleNode(v, "ASH"));
        this.put(new ParticleNode(v, "CRIMSON_SPORE"));
        this.put(new ParticleNode(v, "WARPED_SPORE"));
        this.put(new ParticleNode(v, "DRIPPING_OBSIDIAN_TEAR"));
        this.put(new ParticleNode(v, "FALLING_OBSIDIAN_TEAR"));
        this.put(new ParticleNode(v, "LANDING_OBSIDIAN_TEAR"));
        this.put(new ParticleNode(v, "REVERSE_PORTAL"));
        this.put(new ParticleNode(v, "WHITE_ASH"));
    }

    private void put(ParticleNode node) {
        this.particleMaps.get(node.getVersion().ordinal()).put(node.getName(), node);
    }
}

