/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.core.asm.utils;

import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleVersion;

public class ParticleNode {
    private ParticleNode prev = null;
    private ParticleNode next = null;
    private ParticleVersion version;
    private String name;
    private boolean removed;

    ParticleNode(ParticleVersion version, String name) {
        this(version, name, false);
    }

    ParticleNode(ParticleVersion version, String name, boolean removed) {
        this.version = version;
        this.name = name;
        this.removed = removed;
    }

    ParticleNode follow() {
        ParticleNode node;
        this.next = node = new ParticleNode(this.getNextVersion(), this.name);
        node.prev = this;
        return node;
    }

    ParticleNode follow(String changedName) {
        ParticleNode node;
        this.next = node = new ParticleNode(this.getNextVersion(), changedName);
        node.prev = this;
        return node;
    }

    ParticleNode followForward(String changedName) {
        ParticleNode node;
        this.next = node = new ParticleNode(this.getNextVersion(), changedName);
        node.prev = null;
        return node;
    }

    ParticleNode followBackward(String changedName) {
        ParticleNode node = new ParticleNode(this.getNextVersion(), changedName);
        this.next = null;
        node.prev = this;
        return node;
    }

    ParticleNode followRemoved() {
        ParticleNode node;
        this.next = node = new ParticleNode(this.getNextVersion(), this.name, true);
        node.prev = this;
        return node;
    }

    ParticleNode followRestored() {
        ParticleNode node;
        this.next = node = new ParticleNode(this.getNextVersion(), this.name);
        node.prev = this;
        return node;
    }

    ParticleNode follow(ParticleNode node) {
        this.next = node;
        return node;
    }

    ParticleNode find(ParticleVersion target) {
        if (target.ordinal() < this.version.ordinal()) {
            return this.prev != null ? this.prev.find(target) : null;
        }
        if (target.ordinal() > this.version.ordinal()) {
            return this.next != null ? this.next.find(target) : null;
        }
        return this;
    }

    private ParticleVersion getNextVersion() {
        ParticleVersion[] arr = ParticleVersion.values();
        int next = this.version.ordinal() + 1;
        if (next >= arr.length) {
            throw new IndexOutOfBoundsException("ParticleVersion ordinal (name: " + this.name + " ) exceed bounds (" + next + " >= " + arr.length + ".");
        }
        return arr[next];
    }

    public ParticleVersion getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

