/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.core.asm.utils;

import com.github.fierioziy.particlenativeapi.core.utils.TempClassLoader;
import com.github.fierioziy.particlenativeapi.internal.asm.Type;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;

public class InternalResolver {
    private TempClassLoader cl;
    private String packageVersion;

    InternalResolver() {
    }

    public InternalResolver(JavaPlugin plugin) {
        this.cl = new TempClassLoader(plugin.getClass().getClassLoader());
        this.packageVersion = plugin.getServer().getClass().getPackage().getName().split("\\.")[3];
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public TempClassLoader getTempClassLoader() {
        return this.cl;
    }

    public void setTempClassLoader(TempClassLoader cl) {
        this.cl = cl;
    }

    public Type getNMS(String classPath) {
        return Type.getType(String.format("Lnet/minecraft/server/%s/%s;", this.getPackageVersion(), classPath));
    }

    public Type getOBC(String classPath) {
        return Type.getType(String.format("Lorg/bukkit/craftbukkit/%s/%s;", this.getPackageVersion(), classPath));
    }

    public Set<String> getParticles_1_8() throws ClassNotFoundException {
        Class<?> enumClass = Class.forName(this.getNMS("EnumParticle").getClassName());
        HashSet<String> currentParticleSet = new HashSet<String>();
        for (Object o : enumClass.getEnumConstants()) {
            currentParticleSet.add(((Enum)o).name());
        }
        return currentParticleSet;
    }

    public Set<String> getParticles_1_13() throws ClassNotFoundException {
        Class<?> particleClass = Class.forName(this.getNMS("Particle").getClassName());
        Class<?> particlesClass = Class.forName(this.getNMS("Particles").getClassName());
        HashSet<String> currentParticleSet = new HashSet<String>();
        for (Field f : particlesClass.getFields()) {
            if (!particleClass.isAssignableFrom(f.getType())) continue;
            currentParticleSet.add(f.getName());
        }
        return currentParticleSet;
    }

    public boolean isPacketConstructor_1_7() {
        try {
            Class.forName(this.getNMS("PacketPlayOutWorldParticles").getClassName()).getConstructor(String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isPacketConstructor_1_8() {
        try {
            Class.forName(this.getNMS("PacketPlayOutWorldParticles").getClassName()).getConstructor(Class.forName(this.getNMS("EnumParticle").getClassName()), Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isPacketConstructor_1_13() {
        try {
            Class.forName(this.getNMS("PacketPlayOutWorldParticles").getClassName()).getConstructor(Class.forName(this.getNMS("ParticleParam").getClassName()), Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isPacketConstructor_1_15() {
        try {
            Class.forName(this.getNMS("PacketPlayOutWorldParticles").getClassName()).getConstructor(Class.forName(this.getNMS("ParticleParam").getClassName()), Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }
}

