/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.core.asm.types;

import com.github.fierioziy.particlenativeapi.core.asm.types.ParticleBaseASM;
import com.github.fierioziy.particlenativeapi.core.asm.utils.InternalResolver;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleRegistry;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleTypesImplProvider;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleVersion;
import com.github.fierioziy.particlenativeapi.core.utils.TempClassLoader;
import com.github.fierioziy.particlenativeapi.internal.asm.ClassWriter;
import com.github.fierioziy.particlenativeapi.internal.asm.MethodVisitor;
import com.github.fierioziy.particlenativeapi.internal.asm.Type;
import java.lang.reflect.Method;

public class ParticleTypeASM_1_7
extends ParticleBaseASM
implements ParticleTypesImplProvider {
    private ParticleRegistry particleRegistry = new ParticleRegistry();

    public ParticleTypeASM_1_7(InternalResolver resolver) {
        super(resolver);
    }

    @Override
    protected Type getTypeImpl(Type superType) {
        return this.getTypeImpl(superType, "_1_7");
    }

    @Override
    public void defineImplementation(TempClassLoader cl) {
        this.defineBase(cl, this.particleType);
        this.defineBase(cl, this.particleTypeColorable);
        this.defineBase(cl, this.particleTypeMotion);
        this.defineBase(cl, this.particleTypeNote);
        this.defineBase(cl, this.particleTypeRedstone);
        cl.defineClass(this.getTypeImpl(this.particleTypeBlock).getClassName(), this.createParticleTypeBlockBase(this.particleTypeBlock, this.particleType));
        cl.defineClass(this.getTypeImpl(this.particleTypeBlockMotion).getClassName(), this.createParticleTypeBlockBase(this.particleTypeBlockMotion, this.particleTypeMotion));
        cl.defineClass(this.getTypeImpl(this.particleTypeItemMotion).getClassName(), this.createParticleTypeItemBase(this.particleTypeItemMotion, this.particleTypeMotion));
    }

    private void defineBase(TempClassLoader cl, Type superType) {
        cl.defineClass(this.getTypeImpl(superType).getClassName(), this.createParticleTypeBase(superType));
    }

    @Override
    public void visitParticleTypes(MethodVisitor mv, ParticleVersion interfaceVersion) {
        for (Method m : interfaceVersion.getParticleTypesClass().getDeclaredMethods()) {
            String particleName = m.getName();
            Type particleReturnType = Type.getReturnType(m);
            Type particleReturnTypeImpl = this.getTypeImpl(particleReturnType);
            mv.visitVarInsn(25, 0);
            String resolvedName = this.particleRegistry.find(interfaceVersion, particleName, ParticleVersion.V1_7);
            if (resolvedName != null) {
                mv.visitTypeInsn(187, particleReturnTypeImpl.getInternalName());
                mv.visitInsn(89);
                mv.visitLdcInsn(resolvedName);
                mv.visitMethodInsn(183, particleReturnTypeImpl.getInternalName(), "<init>", "(Ljava/lang/String;)V", false);
            } else {
                this.visitInvalidType(mv, particleReturnType);
            }
            mv.visitFieldInsn(181, interfaceVersion.getImplType().getInternalName(), particleName, particleReturnType.getDescriptor());
        }
    }

    private void visitInvalidType(MethodVisitor mv, Type superType) {
        mv.visitTypeInsn(187, superType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, superType.getInternalName(), "<init>", "()V", false);
    }

    private byte[] createParticleTypeBase(Type superType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw);
        this.visitConstructor(cw, implType, superType);
        this.addIsValid(cw);
        MethodVisitor mv = cw.visitMethod(1, "packet", "(ZDDDDDDDI)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, this.internalNMS("PacketPlayOutWorldParticles"));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implType.getInternalName(), "particle", "Ljava/lang/String;");
        mv.visitVarInsn(24, 2);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 4);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 6);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 8);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 10);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 12);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 14);
        mv.visitInsn(144);
        mv.visitVarInsn(21, 16);
        mv.visitMethodInsn(183, this.internalNMS("PacketPlayOutWorldParticles"), "<init>", "(Ljava/lang/String;FFFFFFFI)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private byte[] createParticleTypeBlockBase(Type superType, Type returnType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        Type implReturnType = this.getTypeImpl(returnType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw);
        this.visitConstructor(cw, implType, superType);
        this.addIsValid(cw);
        MethodVisitor mv = cw.visitMethod(1, "of", "(Lorg/bukkit/Material;B)" + returnType.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, implReturnType.getInternalName());
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implType.getInternalName(), "particle", "Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/bukkit/Material", "getId", "()I", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("_");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(183, implReturnType.getInternalName(), "<init>", "(Ljava/lang/String;)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private byte[] createParticleTypeItemBase(Type superType, Type returnType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        Type implReturnType = this.getTypeImpl(returnType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw);
        this.visitConstructor(cw, implType, superType);
        this.addIsValid(cw);
        MethodVisitor mv = cw.visitMethod(1, "of", "(Lorg/bukkit/Material;)" + returnType.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, implReturnType.getInternalName());
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implType.getInternalName(), "particle", "Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/bukkit/Material", "getId", "()I", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(183, implReturnType.getInternalName(), "<init>", "(Ljava/lang/String;)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void visitFields(ClassWriter cw) {
        cw.visitField(2, "particle", "Ljava/lang/String;", null, null).visitEnd();
    }

    private void visitConstructor(ClassWriter cw, Type implType, Type superType) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/String;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superType.getInternalName(), "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, implType.getInternalName(), "particle", "Ljava/lang/String;");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

