/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.core.asm.types;

import com.github.fierioziy.particlenativeapi.api.types.ParticleType;
import com.github.fierioziy.particlenativeapi.api.types.ParticleTypeRedstone;
import com.github.fierioziy.particlenativeapi.api.utils.ParticleException;
import com.github.fierioziy.particlenativeapi.core.asm.types.ParticleBaseASM;
import com.github.fierioziy.particlenativeapi.core.asm.utils.InternalResolver;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleRegistry;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleTypesImplProvider;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleVersion;
import com.github.fierioziy.particlenativeapi.core.utils.TempClassLoader;
import com.github.fierioziy.particlenativeapi.internal.asm.ClassWriter;
import com.github.fierioziy.particlenativeapi.internal.asm.Label;
import com.github.fierioziy.particlenativeapi.internal.asm.MethodVisitor;
import com.github.fierioziy.particlenativeapi.internal.asm.Type;
import java.lang.reflect.Method;
import java.util.Set;

public class ParticleTypeASM_1_13
extends ParticleBaseASM
implements ParticleTypesImplProvider {
    private ParticleRegistry particleRegistry = new ParticleRegistry();
    private Set<String> currentParticleSet;

    public ParticleTypeASM_1_13(InternalResolver resolver) {
        super(resolver);
        try {
            this.currentParticleSet = resolver.getParticles_1_13();
        }
        catch (ClassNotFoundException e) {
            throw new ParticleException("Error: couldn't find " + this.classNameNMS("Particle") + " and " + this.classNameNMS("Particles") + " classes!");
        }
    }

    @Override
    protected Type getTypeImpl(Type superType) {
        return this.getTypeImpl(superType, "_1_13");
    }

    @Override
    public void defineImplementation(TempClassLoader cl) {
        this.defineBase(cl, this.particleType);
        this.defineBase(cl, this.particleTypeColorable);
        this.defineBase(cl, this.particleTypeMotion);
        this.defineBase(cl, this.particleTypeNote);
        cl.defineClass(this.getTypeImpl(this.particleTypeBlock).getClassName(), this.createParticleTypeBlockBase(this.particleTypeBlock, this.particleType));
        cl.defineClass(this.getTypeImpl(this.particleTypeBlockMotion).getClassName(), this.createParticleTypeBlockBase(this.particleTypeBlockMotion, this.particleTypeMotion));
        cl.defineClass(this.getTypeImpl(this.particleTypeDust).getClassName(), this.createParticleTypeDustBase(this.particleTypeDust, this.particleType));
        cl.defineClass(this.getTypeImpl(this.particleTypeItemMotion).getClassName(), this.createParticleTypeItemBase(this.particleTypeItemMotion, this.particleTypeMotion));
        cl.defineClass(this.getTypeImpl(this.particleTypeRedstone).getClassName(), this.createParticleTypeRedstone(this.particleTypeRedstone));
    }

    private void defineBase(TempClassLoader cl, Type superType) {
        cl.defineClass(this.getTypeImpl(superType).getClassName(), this.createParticleTypeBase(superType));
    }

    @Override
    public void visitParticleTypes(MethodVisitor mv, ParticleVersion interfaceVersion) {
        for (Method m : interfaceVersion.getParticleTypesClass().getDeclaredMethods()) {
            String particleName = m.getName();
            Type particleReturnType = Type.getReturnType(m);
            Type particleReturnTypeImpl = this.getTypeImpl(particleReturnType);
            mv.visitVarInsn(25, 0);
            String resolvedName = this.particleRegistry.find(interfaceVersion, particleName, ParticleVersion.V1_13);
            if (resolvedName != null && this.currentParticleSet.contains(resolvedName)) {
                String particlesFieldDesc;
                String ctrParamDesc;
                mv.visitTypeInsn(187, particleReturnTypeImpl.getInternalName());
                mv.visitInsn(89);
                if (ParticleTypeRedstone.class.isAssignableFrom(m.getReturnType())) {
                    ctrParamDesc = this.descNMS("Particle");
                    particlesFieldDesc = this.descNMS("Particle");
                } else if (ParticleType.class.isAssignableFrom(m.getReturnType())) {
                    ctrParamDesc = this.descNMS("ParticleParam");
                    particlesFieldDesc = this.descNMS("ParticleType");
                } else {
                    ctrParamDesc = this.descNMS("Particle");
                    particlesFieldDesc = this.descNMS("Particle");
                }
                mv.visitFieldInsn(178, this.internalNMS("Particles"), resolvedName, particlesFieldDesc);
                mv.visitMethodInsn(183, particleReturnTypeImpl.getInternalName(), "<init>", "(" + ctrParamDesc + ")V", false);
            } else {
                this.visitInvalidType(mv, particleReturnType);
            }
            mv.visitFieldInsn(181, interfaceVersion.getImplType().getInternalName(), particleName, particleReturnType.getDescriptor());
        }
    }

    private void visitInvalidType(MethodVisitor mv, Type superType) {
        mv.visitTypeInsn(187, superType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, superType.getInternalName(), "<init>", "()V", false);
    }

    protected byte[] createParticleTypeBase(Type superType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw, "ParticleParam");
        this.visitConstructor(cw, implType, superType, "ParticleParam");
        this.addIsValid(cw);
        MethodVisitor mv = cw.visitMethod(1, "packet", "(ZDDDDDDDI)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, this.internalNMS("PacketPlayOutWorldParticles"));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implType.getInternalName(), "particle", this.descNMS("ParticleParam"));
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(24, 2);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 4);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 6);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 8);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 10);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 12);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 14);
        mv.visitInsn(144);
        mv.visitVarInsn(21, 16);
        mv.visitMethodInsn(183, this.internalNMS("PacketPlayOutWorldParticles"), "<init>", "(" + this.descNMS("ParticleParam") + "ZFFFFFFFI)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private byte[] createParticleTypeBlockBase(Type superType, Type returnType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        Type implReturnType = this.getTypeImpl(returnType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw, "Particle");
        this.visitConstructor(cw, implType, superType, "Particle");
        this.addIsValid(cw);
        MethodVisitor mv = cw.visitMethod(1, "of", "(Lorg/bukkit/Material;B)" + returnType.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, implReturnType.getInternalName());
        mv.visitInsn(89);
        mv.visitTypeInsn(187, this.internalNMS("ParticleParamBlock"));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implType.getInternalName(), "particle", this.descNMS("Particle"));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/bukkit/Material", "createBlockData", "()Lorg/bukkit/block/data/BlockData;", false);
        mv.visitTypeInsn(192, this.internalOBC("block/data/CraftBlockData"));
        mv.visitMethodInsn(182, this.internalOBC("block/data/CraftBlockData"), "getState", "()" + this.descNMS("IBlockData"), false);
        mv.visitMethodInsn(183, this.internalNMS("ParticleParamBlock"), "<init>", "(" + this.descNMS("Particle") + this.descNMS("IBlockData") + ")V", false);
        mv.visitMethodInsn(183, implReturnType.getInternalName(), "<init>", "(" + this.descNMS("ParticleParam") + ")V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private byte[] createParticleTypeItemBase(Type superType, Type returnType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        Type implReturnType = this.getTypeImpl(returnType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw, "Particle");
        this.visitConstructor(cw, implType, superType, "Particle");
        this.addIsValid(cw);
        MethodVisitor mv = cw.visitMethod(1, "of", "(Lorg/bukkit/Material;)" + returnType.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, implReturnType.getInternalName());
        mv.visitInsn(89);
        mv.visitTypeInsn(187, this.internalNMS("ParticleParamItem"));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implType.getInternalName(), "particle", this.descNMS("Particle"));
        mv.visitTypeInsn(187, "org/bukkit/inventory/ItemStack");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(4);
        mv.visitMethodInsn(183, "org/bukkit/inventory/ItemStack", "<init>", "(Lorg/bukkit/Material;I)V", false);
        mv.visitMethodInsn(184, this.internalOBC("inventory/CraftItemStack"), "asNMSCopy", "(Lorg/bukkit/inventory/ItemStack;)" + this.descNMS("ItemStack"), false);
        mv.visitMethodInsn(183, this.internalNMS("ParticleParamItem"), "<init>", "(" + this.descNMS("Particle") + this.descNMS("ItemStack") + ")V", false);
        mv.visitMethodInsn(183, implReturnType.getInternalName(), "<init>", "(" + this.descNMS("ParticleParam") + ")V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private byte[] createParticleTypeDustBase(Type superType, Type returnType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        Type implReturnType = this.getTypeImpl(returnType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw, "Particle");
        this.visitConstructor(cw, implType, superType, "Particle");
        this.addIsValid(cw);
        MethodVisitor mv = cw.visitMethod(1, "color", "(FFFF)" + returnType.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, implReturnType.getInternalName());
        mv.visitInsn(89);
        mv.visitTypeInsn(187, this.internalNMS("ParticleParamRedstone"));
        mv.visitInsn(89);
        mv.visitVarInsn(23, 1);
        mv.visitVarInsn(23, 2);
        mv.visitVarInsn(23, 3);
        mv.visitVarInsn(23, 4);
        mv.visitMethodInsn(183, this.internalNMS("ParticleParamRedstone"), "<init>", "(FFFF)V", false);
        mv.visitMethodInsn(183, implReturnType.getInternalName(), "<init>", "(" + this.descNMS("ParticleParam") + ")V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected byte[] createParticleTypeRedstone(Type superType) {
        ClassWriter cw = new ClassWriter(3);
        Type implType = this.getTypeImpl(superType);
        cw.visit(51, 33, implType.getInternalName(), null, superType.getInternalName(), null);
        this.visitFields(cw, "ParticleParam");
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + this.descNMS("Particle") + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superType.getInternalName(), "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, this.internalNMS("ParticleParamRedstone"));
        mv.visitInsn(89);
        mv.visitInsn(12);
        mv.visitInsn(11);
        mv.visitInsn(11);
        mv.visitInsn(12);
        mv.visitMethodInsn(183, this.internalNMS("ParticleParamRedstone"), "<init>", "(FFFF)V", false);
        mv.visitFieldInsn(181, implType.getInternalName(), "particle", this.descNMS("ParticleParam"));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.addIsValid(cw);
        mv = cw.visitMethod(1, "packet", "(ZDDDDDDDI)Ljava/lang/Object;", null, null);
        mv.visitCode();
        Label zeroCountLabel = new Label();
        mv.visitVarInsn(21, 16);
        mv.visitJumpInsn(153, zeroCountLabel);
        mv.visitTypeInsn(187, this.internalNMS("PacketPlayOutWorldParticles"));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implType.getInternalName(), "particle", this.descNMS("ParticleParam"));
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(24, 2);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 4);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 6);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 8);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 10);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 12);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 14);
        mv.visitInsn(144);
        mv.visitVarInsn(21, 16);
        mv.visitMethodInsn(183, this.internalNMS("PacketPlayOutWorldParticles"), "<init>", "(" + this.descNMS("ParticleParam") + "ZFFFFFFFI)V", false);
        mv.visitInsn(176);
        mv.visitLabel(zeroCountLabel);
        mv.visitTypeInsn(187, this.internalNMS("PacketPlayOutWorldParticles"));
        mv.visitInsn(89);
        mv.visitTypeInsn(187, this.internalNMS("ParticleParamRedstone"));
        mv.visitInsn(89);
        mv.visitVarInsn(24, 8);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 10);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 12);
        mv.visitInsn(144);
        mv.visitInsn(12);
        mv.visitMethodInsn(183, this.internalNMS("ParticleParamRedstone"), "<init>", "(FFFF)V", false);
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(24, 2);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 4);
        mv.visitInsn(144);
        mv.visitVarInsn(24, 6);
        mv.visitInsn(144);
        mv.visitInsn(11);
        mv.visitInsn(11);
        mv.visitInsn(11);
        mv.visitInsn(11);
        mv.visitInsn(4);
        mv.visitMethodInsn(183, this.internalNMS("PacketPlayOutWorldParticles"), "<init>", "(" + this.descNMS("ParticleParam") + "ZFFFFFFFI)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void visitFields(ClassWriter cw, String fieldType) {
        cw.visitField(2, "particle", this.descNMS(fieldType), null, null).visitEnd();
    }

    protected void visitConstructor(ClassWriter cw, Type implType, Type superType, String fieldType) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + this.descNMS(fieldType) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superType.getInternalName(), "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, implType.getInternalName(), "particle", this.descNMS(fieldType));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

