/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.core.asm;

import com.github.fierioziy.particlenativeapi.api.utils.ParticleException;
import com.github.fierioziy.particlenativeapi.core.asm.ConnectionBaseASM;
import com.github.fierioziy.particlenativeapi.core.asm.types.ParticleTypeASM_1_13;
import com.github.fierioziy.particlenativeapi.core.asm.types.ParticleTypeASM_1_15;
import com.github.fierioziy.particlenativeapi.core.asm.types.ParticleTypeASM_1_7;
import com.github.fierioziy.particlenativeapi.core.asm.types.ParticleTypeASM_1_8;
import com.github.fierioziy.particlenativeapi.core.asm.utils.InternalResolver;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleTypesImplProvider;
import com.github.fierioziy.particlenativeapi.core.asm.utils.ParticleVersion;
import com.github.fierioziy.particlenativeapi.internal.asm.ClassWriter;
import com.github.fierioziy.particlenativeapi.internal.asm.MethodVisitor;
import com.github.fierioziy.particlenativeapi.internal.asm.Type;
import java.lang.reflect.Method;

public class ParticlesASM
extends ConnectionBaseASM {
    private ParticleTypesImplProvider implProvider;

    public ParticlesASM(InternalResolver resolver) {
        super(resolver);
        if (this.internal.isPacketConstructor_1_7()) {
            this.implProvider = new ParticleTypeASM_1_7(resolver);
        } else if (this.internal.isPacketConstructor_1_8()) {
            this.implProvider = new ParticleTypeASM_1_8(resolver);
        } else if (this.internal.isPacketConstructor_1_13()) {
            this.implProvider = new ParticleTypeASM_1_13(resolver);
        } else if (this.internal.isPacketConstructor_1_15()) {
            this.implProvider = new ParticleTypeASM_1_15(resolver);
        } else {
            throw new ParticleException("Error: this server version is not supported!");
        }
        this.implProvider.defineImplementation(resolver.getTempClassLoader());
    }

    public byte[] generateParticles_1_8() {
        return this.generateParticlesList(ParticleVersion.V1_8);
    }

    public byte[] generateParticles_1_13() {
        return this.generateParticlesList(ParticleVersion.V1_13);
    }

    private byte[] generateParticlesList(ParticleVersion interfaceVersion) {
        ClassWriter cw = new ClassWriter(3);
        Type superType = interfaceVersion.getSuperType();
        Type implType = interfaceVersion.getImplType();
        cw.visit(51, 33, implType.getInternalName(), null, this.serverConnTypeImpl.getInternalName(), new String[]{superType.getInternalName()});
        this.visitFields(cw, interfaceVersion);
        this.visitConstructor(cw, interfaceVersion);
        for (Method m : interfaceVersion.getParticleTypesClass().getDeclaredMethods()) {
            String particleName = m.getName();
            MethodVisitor mv = cw.visitMethod(1, particleName, Type.getMethodDescriptor(m), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, implType.getInternalName(), particleName, Type.getReturnType(m).getDescriptor());
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void visitFields(ClassWriter cw, ParticleVersion interfaceVersion) {
        for (Method m : interfaceVersion.getParticleTypesClass().getDeclaredMethods()) {
            cw.visitField(2, m.getName(), Type.getReturnType(m).getDescriptor(), null, null).visitEnd();
        }
    }

    private void visitConstructor(ClassWriter cw, ParticleVersion interfaceVersion) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.serverConnTypeImpl.getInternalName(), "<init>", "()V", false);
        this.implProvider.visitParticleTypes(mv, interfaceVersion);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

