/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.core;

import com.github.fierioziy.particlenativeapi.api.ParticleNativeAPI;
import com.github.fierioziy.particlenativeapi.api.Particles_1_13;
import com.github.fierioziy.particlenativeapi.api.Particles_1_8;
import com.github.fierioziy.particlenativeapi.api.PlayerConnection;
import com.github.fierioziy.particlenativeapi.api.ServerConnection;
import com.github.fierioziy.particlenativeapi.api.utils.ParticleException;
import com.github.fierioziy.particlenativeapi.core.asm.ParticlesASM;
import com.github.fierioziy.particlenativeapi.core.asm.PlayerConnectionASM;
import com.github.fierioziy.particlenativeapi.core.asm.ServerConnectionASM;
import com.github.fierioziy.particlenativeapi.core.asm.utils.InternalResolver;
import com.github.fierioziy.particlenativeapi.core.utils.TempClassLoader;
import com.github.fierioziy.particlenativeapi.internal.asm.Type;
import org.bukkit.plugin.java.JavaPlugin;

public class ParticleNativeCore
implements ParticleNativeAPI {
    private TempClassLoader cl;
    private ServerConnection serverConnection;
    private Particles_1_8 particles_1_8;
    private Particles_1_13 particles_1_13;

    ParticleNativeCore() {
    }

    public static ParticleNativeAPI loadAPI(JavaPlugin plugin) throws ParticleException {
        return new ParticleNativeCore().setupCore(plugin);
    }

    ParticleNativeAPI setupCore(JavaPlugin plugin) throws ParticleException {
        try {
            InternalResolver resolver = this.resolveInternals(plugin);
            this.cl = resolver.getTempClassLoader();
            PlayerConnectionASM pcASM = new PlayerConnectionASM(resolver);
            this.define(PlayerConnection.class, pcASM.generatePlayerConnectionCode());
            ServerConnectionASM scASM = new ServerConnectionASM(resolver);
            this.serverConnection = this.defineAndGet(ServerConnection.class, scASM.generateServerConnectionCode());
            ParticlesASM pASM = new ParticlesASM(resolver);
            this.particles_1_8 = this.defineAndGet(Particles_1_8.class, pASM.generateParticles_1_8());
            this.particles_1_13 = this.defineAndGet(Particles_1_13.class, pASM.generateParticles_1_13());
            return this;
        }
        catch (Exception e) {
            throw new ParticleException("Failed to load particle library.", e);
        }
    }

    InternalResolver resolveInternals(JavaPlugin plugin) {
        return new InternalResolver(plugin);
    }

    private <T> T defineAndGet(Class<T> clazz, byte[] code) throws Exception {
        return clazz.cast(this.define(clazz, code).getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private Class<?> define(Class<?> clazz, byte[] code) {
        return this.cl.defineClass(Type.getType(clazz).getClassName() + "_Impl", code);
    }

    @Override
    public Particles_1_8 getParticles_1_8() {
        return this.particles_1_8;
    }

    @Override
    public Particles_1_13 getParticles_1_13() {
        return this.particles_1_13;
    }

    @Override
    @Deprecated
    public ServerConnection getServerConnection() {
        return this.serverConnection;
    }
}

