/*
 * Decompiled with CFR 0.152.
 */
package com.github.fierioziy.particlenativeapi.api.types;

import com.github.fierioziy.particlenativeapi.api.types.ParticleType;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleTypeNote
extends ParticleType {
    public Object packetNote(boolean far, Location loc, Color color) {
        return this.packetNote(far, loc.getX(), loc.getY(), loc.getZ(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public Object packetNote(boolean far, Vector loc, Color color) {
        return this.packetNote(far, loc.getX(), loc.getY(), loc.getZ(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public Object packetNote(boolean far, double x, double y, double z, Color color) {
        return this.packetNote(far, x, y, z, color.getRed(), color.getGreen(), color.getBlue());
    }

    public Object packetNote(boolean far, Location loc, int r, int g, int b) {
        return this.packetNote(far, loc.getX(), loc.getY(), loc.getZ(), r, g, b);
    }

    public Object packetNote(boolean far, Vector loc, int r, int g, int b) {
        return this.packetNote(far, loc.getX(), loc.getY(), loc.getZ(), r, g, b);
    }

    public Object packetNote(boolean far, double x, double y, double z, int r, int g, int b) {
        r = Math.min(Math.max(r, 0), 255);
        g = Math.min(Math.max(g, 0), 255);
        b = Math.min(Math.max(b, 0), 255);
        if (r != 255 && g != 255 && b != 255) {
            throw new UnsupportedOperationException("At least one color channel in (" + r + ", " + g + ", " + b + ") must have value of 255 to make note color!");
        }
        double rr = 4.0 * (double)r / 255.0;
        double gg = 4.0 * (double)g / 255.0;
        double bb = 4.0 * (double)b / 255.0;
        if (b == 0) {
            rr = (rr = 2.0 + rr - gg) < 0.0 ? rr + 24.0 : rr;
        } else if (r == 0) {
            rr = 18.0 + gg - bb;
        } else if (g == 0) {
            rr = 10.0 - rr + bb;
        } else {
            throw new UnsupportedOperationException("All color channels in (" + r + ", " + g + ", " + b + ") can't be used to make note color!");
        }
        return this.packet(far, x, y, z, rr / 24.0, 0.0, 0.0, 1.0, 0);
    }

    public Object packetNote(boolean far, Location loc, double color) {
        return this.packet(far, loc.getX(), loc.getY(), loc.getZ(), color, 0.0, 0.0, 1.0, 0);
    }

    public Object packetNote(boolean far, Vector loc, double color) {
        return this.packet(far, loc.getX(), loc.getY(), loc.getZ(), color, 0.0, 0.0, 1.0, 0);
    }

    public Object packetNote(boolean far, double x, double y, double z, double color) {
        return this.packet(far, x, y, z, color, 0.0, 0.0, 1.0, 0);
    }
}

