/*
 * Decompiled with CFR 0.152.
 */
package com.Superbility.SkyblockItems.Items.NinjaStar;

import com.Superbility.SkyblockItems.Items.NinjaStar.NinjaStarHit;
import com.Superbility.SkyblockItems.Main;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class NinjaStarThrow
implements Listener {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private NinjaStarHit starHit = new NinjaStarHit();
    private ArrayList<Player> cooldown = new ArrayList();

    @EventHandler
    private void onClick(PlayerInteractEvent e) {
        ItemStack item;
        NBTItem nbtItem;
        if (e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && e.getPlayer().getItemInHand() != null && (nbtItem = new NBTItem(item = e.getPlayer().getItemInHand())).hasKey("itemKey").booleanValue()) {
            if (this.cooldown.contains(e.getPlayer())) {
                e.getPlayer().sendMessage(ChatColor.RED + "This item is currently on cooldown!");
                return;
            }
            this.addPlayerCooldown(e.getPlayer(), 4);
            String key = nbtItem.getString("itemKey");
            if (key.contains("ninjastar")) {
                String type = key.split(":")[1];
                Vector direction = e.getPlayer().getLocation().getDirection();
                Location location = e.getPlayer().getLocation();
                this.createStar(type, direction, location);
            }
        }
    }

    private void createStar(String type, Vector direction, Location location) {
        ArmorStand stand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        stand.setMetadata("standType", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"projectile"));
        stand.setMetadata("projectileType", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"ninjaStar"));
        stand.setMetadata("ninjaStarType", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)type));
        stand.setVisible(false);
        stand.setItemInHand(new ItemStack(Material.NETHER_STAR));
        stand.setVelocity(direction);
        stand.setRightArmPose(new EulerAngle(Math.toRadians(90.0), Math.toRadians(180.0), Math.toRadians(0.0)));
        stand.setArms(true);
        this.removeStar(stand, 60, direction);
    }

    private void removeStar(final ArmorStand stand, final int delay, final Vector direction) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!stand.isDead() && stand != null) {
                    ++this.counter;
                    stand.setVelocity(direction);
                    stand.setRightArmPose(new EulerAngle(Math.toRadians(0.0), Math.toRadians(180 + this.counter * 50), Math.toRadians(90.0)));
                    NinjaStarThrow.this.starHit.checkCollision(stand);
                    if (this.counter >= delay) {
                        stand.remove();
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    private void addPlayerCooldown(final Player player, int delay) {
        this.cooldown.add(player);
        new BukkitRunnable(){

            public void run() {
                NinjaStarThrow.this.cooldown.remove(player);
            }
        }.runTaskLater((Plugin)this.plugin, (long)delay);
    }
}

