/*
 * Decompiled with CFR 0.152.
 */
package com.Superbility.SkyblockItems.Items.JerryFlux;

import com.Superbility.SkyblockItems.Main;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class JerryFluxEvents
implements Listener {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private ArrayList<Player> cooldownPlayers = new ArrayList();

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        NBTItem item = new NBTItem(e.getItemInHand());
        if (item.hasKey("itemKey").booleanValue() && item.getString("itemKey").equals("item_jerryflux")) {
            e.setCancelled(true);
            if (this.cooldownPlayers.contains(e.getPlayer())) {
                e.getPlayer().sendMessage(ChatColor.RED + "You are currently on cooldown! Please wait before trying again.");
                return;
            }
            this.addPlayerToCooldown(e.getPlayer(), 600);
            this.placeOrb(e.getItemInHand(), e.getBlockPlaced().getLocation());
        }
    }

    private void addPlayerToCooldown(final Player player, Integer time) {
        this.cooldownPlayers.add(player);
        new BukkitRunnable(){

            public void run() {
                JerryFluxEvents.this.cooldownPlayers.remove(player);
            }
        }.runTaskLater((Plugin)this.plugin, (long)time.intValue());
    }

    private void placeOrb(ItemStack item, Location location) {
        ArmorStand mainStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        mainStand.setHelmet(item);
        mainStand.setGravity(false);
        mainStand.setVisible(false);
        this.orbCooldown(mainStand, 600);
        this.move(mainStand);
        this.startAbility(mainStand.getEyeLocation(), mainStand);
    }

    private void orbCooldown(final ArmorStand mainStand, Integer time) {
        new BukkitRunnable(){

            public void run() {
                mainStand.remove();
            }
        }.runTaskLater((Plugin)this.plugin, (long)time.intValue());
    }

    private void move(final ArmorStand stand) {
        final Location loc = stand.getLocation();
        new BukkitRunnable(){
            private boolean goingUp = true;
            private final int maxHeight = loc.getBlockY() + 2;
            private final int minHeight = loc.getBlockY();

            public void run() {
                if (stand != null) {
                    if (this.goingUp) {
                        if (stand.getLocation().getY() > (double)this.maxHeight) {
                            this.goingUp = false;
                        } else {
                            loc.setYaw(loc.getYaw() + 7.0f);
                            stand.teleport(loc.add(0.0, 0.07, 0.0));
                            JerryFluxEvents.this.playerParticles(stand.getEyeLocation(), stand);
                        }
                    } else if (stand.getLocation().getY() < (double)this.minHeight) {
                        this.goingUp = true;
                    } else {
                        loc.setYaw(loc.getYaw() + 7.0f);
                        stand.teleport(loc.add(0.0, -0.07, 0.0));
                        JerryFluxEvents.this.playerParticles(stand.getEyeLocation(), stand);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    private void playerParticles(Location location, ArmorStand stand) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals(location.getWorld()) || !(player.getLocation().distance(location) < 20.0)) continue;
            Location loc = location.clone();
            Vector vec = stand.getLocation().getDirection();
            Location frontLocation = loc.clone().add(vec);
            Location backLocation = loc.clone().subtract(vec);
            player.playEffect(frontLocation, Effect.HAPPY_VILLAGER, 0);
            player.playEffect(backLocation, Effect.HAPPY_VILLAGER, 0);
            player.playEffect(frontLocation, Effect.WITCH_MAGIC, 0);
            player.playEffect(backLocation, Effect.WITCH_MAGIC, 0);
            player.playEffect(loc, Effect.SMOKE, 0);
        }
    }

    private void startAbility(final Location location, final ArmorStand stand) {
        new BukkitRunnable(){

            public void run() {
                if (stand.isDead() || stand == null) {
                    this.cancel();
                    return;
                }
                for (LivingEntity entity : location.getWorld().getLivingEntities()) {
                    if (!(entity.getLocation().distance(location) < 10.0) || entity instanceof Player || entity instanceof ArmorStand || entity instanceof Villager) continue;
                    JerryFluxEvents.this.drawLine(location, entity.getEyeLocation(), 0.1);
                    entity.getWorld().createExplosion(entity.getLocation(), 0.0f, false);
                    entity.getWorld().spawnEntity(entity.getLocation(), EntityType.VILLAGER);
                    entity.remove();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void drawLine(Location point1, Location point2, double space) {
        World world = point1.getWorld();
        Validate.isTrue((boolean)point2.getWorld().equals(world), (String)"Lines cannot be in different worlds!");
        double distance = point1.distance(point2);
        Vector p1 = point1.toVector();
        Vector p2 = point2.toVector();
        Vector vector = p2.clone().subtract(p1).normalize().multiply(space);
        for (double length = 0.0; length < distance; length += space) {
            Location location = new Location(point1.getWorld(), p1.getX(), p1.getY(), p1.getZ());
            world.playEffect(location, Effect.HEART, 1);
            p1.add(vector);
        }
    }
}

