/*
 * Decompiled with CFR 0.152.
 */
package com.Superbility.SkyblockItems.Items.Fertilizer;

import com.Superbility.SkyblockItems.Items.Fertilizer.NutrientPowerLore;
import com.Superbility.SkyblockItems.Main;
import com.Superbility.SkyblockItems.Utils.ForceGrow;
import com.github.fierioziy.particlenativeapi.api.ParticleNativeAPI;
import com.github.fierioziy.particlenativeapi.api.Particles_1_8;
import com.github.fierioziy.particlenativeapi.core.ParticleNativeCore;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.CropState;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SuperGrowthEvents
implements Listener {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private NutrientPowerLore npl = new NutrientPowerLore();

    @EventHandler
    private void onClick(PlayerInteractEvent e) {
        NBTItem nbtItem;
        if ((e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) && e.getPlayer().getItemInHand() != null && e.getPlayer().getItemInHand().getType() != Material.AIR && (nbtItem = new NBTItem(e.getPlayer().getItemInHand())).hasKey("itemKey").booleanValue() && nbtItem.getString("itemKey").equals("item_fertilizer")) {
            e.setCancelled(true);
            int progress = nbtItem.getInteger("nutrientPower");
            if (progress >= 100) {
                nbtItem.setInteger("nutrientPower", 0);
                ItemStack finalItem = nbtItem.getItem();
                this.npl.updateNutrientPowerLore(finalItem.getItemMeta(), 0, finalItem);
                e.getPlayer().setItemInHand(finalItem);
                this.growBlocks(e.getPlayer().getLocation(), e.getPlayer());
                this.particles(e.getPlayer().getLocation(), e.getPlayer());
                e.getPlayer().getWorld().playSound(e.getPlayer().getLocation(), Sound.LEVEL_UP, 10.0f, 5.0f);
                e.getPlayer().sendMessage(ChatColor.GREEN + "Fertilizer used! Nutrient power is now back to 0.");
            } else {
                e.getPlayer().getWorld().playSound(e.getPlayer().getLocation(), Sound.VILLAGER_HIT, 10.0f, 1.0f);
                e.getPlayer().sendMessage(ChatColor.RED + "The Fertilizer doesn't have enough nutrient power!");
            }
        }
    }

    private void particles(final Location location, final Player player) {
        final ParticleNativeAPI api = ParticleNativeCore.loadAPI(this.plugin);
        new BukkitRunnable(){
            double t = 0.7853981633974483;
            Location loc = location.add(0.5, 0.0, 0.5);

            public void run() {
                Particles_1_8 particles = api.getParticles_1_8();
                this.t += 0.3141592653589793;
                for (double theta = 0.0; theta <= Math.PI * 2; theta += 0.09817477042468103) {
                    double x = this.t * Math.cos(theta);
                    double y = 2.0 * Math.exp(-0.1 * this.t) * Math.sin(this.t) + 1.5;
                    double z = this.t * Math.sin(theta);
                    this.loc.add(x, y, z);
                    Object packet1 = particles.VILLAGER_HAPPY().packet(true, this.loc);
                    this.loc.subtract(x, y, z);
                    x = this.t * Math.cos(theta += 0.04908738521234052);
                    y = 2.0 * Math.exp(-0.1 * this.t) * Math.sin(this.t) + 1.5;
                    z = this.t * Math.sin(theta);
                    this.loc.add(x, y, z);
                    Object packet2 = particles.SPELL_WITCH().packet(true, this.loc);
                    this.loc.subtract(x, y, z);
                    particles.sendPacket(player, packet1);
                    particles.sendPacket(player, packet2);
                }
                if (this.t > 20.0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void growBlocks(Location location, Player player) {
        final ArrayList<Block> blocks = new ArrayList<Block>();
        int radius = 20;
        for (double x = location.getX() - (double)radius; x <= location.getX() + (double)radius; x += 1.0) {
            for (double y = location.getY() - (double)radius; y <= location.getY() + (double)radius; y += 1.0) {
                for (double z = location.getZ() - (double)radius; z <= location.getZ() + (double)radius; z += 1.0) {
                    Location loc = new Location(location.getWorld(), x, y, z);
                    ArrayList<Material> types = new ArrayList<Material>(Arrays.asList(Material.CROPS, Material.SUGAR_CANE_BLOCK, Material.MELON_STEM, Material.PUMPKIN_STEM, Material.CACTUS, Material.NETHER_STALK, Material.POTATO, Material.CARROT));
                    if (!types.contains(loc.getBlock().getType())) continue;
                    blocks.add(loc.getBlock());
                }
            }
        }
        new BukkitRunnable(){
            int counter;
            {
                this.counter = blocks.size();
            }

            public void run() {
                --this.counter;
                if (this.counter < 1) {
                    this.cancel();
                }
                Block block = (Block)blocks.get(this.counter);
                Material type = block.getType();
                switch (type) {
                    case CROPS: {
                        block.setData(CropState.RIPE.getData());
                    }
                    case SUGAR_CANE_BLOCK: {
                        ForceGrow.growReeds(block);
                    }
                    case MELON_STEM: {
                        ForceGrow.growPumpkinMelon(block, Material.MELON_BLOCK);
                    }
                    case PUMPKIN_STEM: {
                        ForceGrow.growPumpkinMelon(block, Material.PUMPKIN);
                    }
                    case CACTUS: {
                        ForceGrow.growCactus(block);
                    }
                    case CARROT: {
                        block.setData(CropState.RIPE.getData());
                    }
                    case POTATO: {
                        block.setData(CropState.RIPE.getData());
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

