/*
 * Decompiled with CFR 0.152.
 */
package com.Superbility.SkyblockItems.Commands;

import com.Superbility.SkyblockItems.Items.Fertilizer.NutrientPowerLore;
import com.Superbility.SkyblockItems.Items.Manager.ItemManager;
import com.Superbility.SkyblockItems.Items.Manager.Rarity;
import com.Superbility.SkyblockItems.Items.NinjaStar.NinjaStarType;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
implements CommandExecutor {
    private ItemManager itemManager = new ItemManager();
    private HeadDatabaseAPI hdb = new HeadDatabaseAPI();
    private NutrientPowerLore npl = new NutrientPowerLore();

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("item") && sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("Scaffold")) {
                    player.getInventory().setItemInHand(this.scaffoldItem());
                    return true;
                }
                if (args[0].equalsIgnoreCase("JerryFlux")) {
                    player.getInventory().setItemInHand(this.jerryFluxItem());
                    return true;
                }
                if (args[0].equalsIgnoreCase("fertilizer")) {
                    if (args.length > 1) {
                        int progress = Integer.valueOf(args[1]);
                        player.getInventory().setItemInHand(this.fertilizerItem(progress));
                        return true;
                    }
                    player.getInventory().setItemInHand(this.fertilizerItem(0));
                    return true;
                }
                if (args[0].equalsIgnoreCase("NinjaStar")) {
                    if (args.length > 1) {
                        if (args[1].equalsIgnoreCase("lightning")) {
                            player.getInventory().setItemInHand(this.ninjaStarItem(NinjaStarType.LIGHTNING));
                            return true;
                        }
                        if (args[1].equalsIgnoreCase("explosive")) {
                            player.getInventory().setItemInHand(this.ninjaStarItem(NinjaStarType.EXPLOSIVE));
                            return true;
                        }
                    }
                    player.getInventory().setItemInHand(this.ninjaStarItem(NinjaStarType.DEFAULT));
                    return true;
                }
            }
        }
        return false;
    }

    private ItemStack scaffoldItem() {
        Material scaffoldItemMaterial = Material.BEDROCK;
        Rarity scaffoldItemRarity = Rarity.GODLY;
        String scaffoldItemName = scaffoldItemRarity.getColor() + "Auto-Scaffold";
        List<String> scaffoldItemLore = Arrays.asList(" ", "&7Used by only the most godlike of players!", "&7Forged deep within the &2Dwarven Mines&7 by", "&7the ancient miners!", " ", "&8'Just a good gaming chair'", "", scaffoldItemRarity.getDisplayName() + " ITEM");
        String scaffoldItemKey = "item_scaffold";
        return this.itemManager.registerItem(scaffoldItemMaterial, scaffoldItemName, scaffoldItemLore, scaffoldItemRarity, scaffoldItemKey);
    }

    private ItemStack jerryFluxItem() {
        ItemStack jerryFluxMaterial = this.hdb.getItemHead("32845");
        Rarity jerryFluxRarity = Rarity.MYTHIC;
        String jerryFluxName = jerryFluxRarity.getColor() + "Jerry-Flux Power Orb";
        List<String> jerryFluxLore = Arrays.asList(" ", "&7Crafted using only the purest", "&7of Jerry eggs. Grants the user and", "&7nearby players supernatural abilities!", "", jerryFluxRarity.getColor() + "Item Ability: Jerry Beam &e&lRIGHT CLICK", "&7Jerry will channel his inner Jerryness and", "&7send out powerful beams of love, transforming", "&7enemies into lovable Jerry's!", "&8Cooldown: &a30s", "", "&8'MMMMMM'", "", jerryFluxRarity.getDisplayName() + " ITEM");
        String jerryFluxKey = "item_jerryflux";
        return this.itemManager.registerItem(jerryFluxMaterial, jerryFluxName, jerryFluxLore, jerryFluxRarity, jerryFluxKey);
    }

    private ItemStack ninjaStarItem(NinjaStarType type) {
        ItemStack ninjaStarMaterial = new ItemStack(Material.NETHER_STAR);
        Rarity ninjaStarRarity = Rarity.RARE;
        String ninjaStarName = ninjaStarRarity.getColor() + type.getDisplayName() + " Ninja Star";
        List<String> ninjaStarLore = this.getNinjaStarLore(ninjaStarRarity, type);
        String ninjaStarKey = "item_ninjastar:" + type.getKey();
        return this.itemManager.registerItem(ninjaStarMaterial, ninjaStarName, ninjaStarLore, ninjaStarRarity, ninjaStarKey);
    }

    private List<String> getNinjaStarLore(Rarity ninjaStarRarity, NinjaStarType type) {
        List<String> ninjaStarLore1 = Arrays.asList(" ", "&7Forged in the heart of a star with", "&7only the strongest &ftitanium&7", "", ninjaStarRarity.getColor() + "Item Ability: Silent Fury &e&lRIGHT CLICK", "&7Right click to throw this insanely", "&7deadly projectile, dealing &c5 damage&7!", "&8Cooldown: &a0.2s");
        List<String> ninjaStarLore2 = type.getTypeAbility(ninjaStarRarity);
        List<String> ninjaStarLore3 = Arrays.asList("&8Silent as the night", "&8Fast as lightning", "&8Sharp as a dragon claw", "", ninjaStarRarity.getDisplayName() + " ITEM");
        ArrayList<String> finalLore = new ArrayList<String>();
        finalLore.addAll(ninjaStarLore1);
        finalLore.addAll(ninjaStarLore2);
        finalLore.addAll(ninjaStarLore3);
        return finalLore;
    }

    private ItemStack fertilizerItem(int progress) {
        ItemStack fertilizerMaterial = this.hdb.getItemHead("25735");
        Rarity fertilizerRarity = Rarity.EPIC;
        String fertilizerName = fertilizerRarity.getColor() + "Fertilizer";
        List<String> fertilizerLore = Arrays.asList(" ", "&7Collects nutrients over time while", "&7farming increasing your &dnutrient", "&dpower&7! Must be in your inventory to", "&7absorb nutrients.", "", fertilizerRarity.getColor() + "Item Ability: Super Growth &e&lRIGHT CLICK", "&7Sends out a wave of energy to all", "&7crops in a &a20 &7block radius, instantly", "&7growing them!", "&8Drains all current nutrient power", " ", "&dNutrient Power: {nutrientpower_progress}", " ", "&8Bonemeal? What's that?", " ", fertilizerRarity.getDisplayName() + " ITEM");
        String fertilizerKey = "item_fertilizer";
        ItemStack returnedItem = this.itemManager.registerItem(fertilizerMaterial, fertilizerName, fertilizerLore, fertilizerRarity, fertilizerKey);
        this.npl.updateNutrientPowerLore(returnedItem.getItemMeta(), progress, returnedItem);
        NBTItem nbtItem = new NBTItem(returnedItem);
        nbtItem.setInteger("nutrientPower", progress);
        return nbtItem.getItem();
    }
}

