/*
 * Decompiled with CFR 0.152.
 */
package club.luxorlandia.events.Invisible;

import club.luxorlandia.Main;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Invisibility
implements Listener {
    public static ArrayList<UUID> invisList = new ArrayList();

    @EventHandler(priority=EventPriority.LOWEST)
    public void _onPotion(PlayerItemConsumeEvent event) {
        if (!Main.plugin.getAddonsConfig().getBoolean("Addons.Invisibility")) {
            return;
        }
        if (event.getItem().getType() == Material.POTION && Potion.fromItemStack((ItemStack)event.getItem()).getType() == PotionType.INVISIBILITY) {
            Player player = event.getPlayer();
            this.hideArmor(player);
            player.sendMessage(Main.plugin.getMessagesConfig().getString("Invisibility-Messages.invisible").replace("&", "\u00a7"));
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            ((Team)scoreboard).setNameTagVisibility(NameTagVisibility.NEVER);
            ((Team)scoreboard).addEntry(player.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void _onDamage(EntityDamageByEntityEvent event) {
        if (!Main.plugin.getAddonsConfig().getBoolean("Addons.Invisibility")) {
            return;
        }
        if (!(event.getEntity() instanceof Player) || !(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (invisList.contains(player.getUniqueId())) {
            player.sendMessage(Main.plugin.getMessagesConfig().getString("Invisibility-Messages.visible").replace("&", "\u00a7"));
            Invisibility.restoreArmor(player);
            for (PotionEffect effect : player.getActivePotionEffects()) {
                effect.getType();
                player.removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            ((Team)scoreboard).setNameTagVisibility(NameTagVisibility.ALWAYS);
            ((Team)scoreboard).addEntry(player.getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void _onQuit(PlayerQuitEvent event) {
        invisList.remove(event.getPlayer().getUniqueId());
    }

    private void hideArmor(Player player) {
        Invisibility.broadcastNearby(player, this.setAir(player, 1));
        Invisibility.broadcastNearby(player, this.setAir(player, 2));
        Invisibility.broadcastNearby(player, this.setAir(player, 3));
        Invisibility.broadcastNearby(player, this.setAir(player, 4));
        invisList.add(player.getUniqueId());
    }

    public static void restoreArmor(Player player) {
        invisList.remove(player.getUniqueId());
        Invisibility.broadcastNearby(player, Invisibility.setItem(player, player.getInventory().getBoots(), 1));
        Invisibility.broadcastNearby(player, Invisibility.setItem(player, player.getInventory().getLeggings(), 2));
        Invisibility.broadcastNearby(player, Invisibility.setItem(player, player.getInventory().getChestplate(), 3));
        Invisibility.broadcastNearby(player, Invisibility.setItem(player, player.getInventory().getHelmet(), 4));
    }

    private static void broadcastNearby(Player player, PacketContainer packet) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        for (Player observer : manager.getEntityTrackers((Entity)player)) {
            try {
                manager.sendServerPacket(observer, packet);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Cannot send packet.", e);
            }
        }
    }

    private PacketContainer setAir(Player player, int slot) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        packet.getEntityModifier(player.getWorld()).write(0, (Object)player);
        packet.getIntegers().write(1, (Object)slot);
        packet.getItemModifier().write(0, (Object)new ItemStack(Material.AIR));
        return packet;
    }

    private static PacketContainer setItem(Player player, ItemStack item, int slot) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        packet.getEntityModifier(player.getWorld()).write(0, (Object)player);
        packet.getIntegers().write(1, (Object)slot);
        packet.getItemModifier().write(0, (Object)item);
        return packet;
    }
}

