/*
 * Decompiled with CFR 0.152.
 */
package club.luxorlandia.events;

import club.luxorlandia.Main;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FireBallKnockBack
implements Listener {
    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        List effects;
        Main plugin = Main.getInstance();
        if (plugin.getConfig().getBoolean("Throw-Effects.enabled") && (e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) && (e.getPlayer().getItemInHand().getType().name().equals("FIRE_CHARGE") || e.getPlayer().getItemInHand().getType().name().equals("FIREBALL")) && (effects = plugin.getConfig().getStringList("Throw-Effects.effects")) != null) {
            effects.forEach(element -> {
                String[] tokens = element.split(":");
                PotionEffectType effect = PotionEffectType.getByName((String)tokens[0].toUpperCase());
                if (effect != null) {
                    e.getPlayer().addPotionEffect(new PotionEffect(effect, Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), true, false));
                }
            });
        }
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent e) {
        Main plugin = Main.getInstance();
        Location l = e.getLocation();
        double radius = plugin.getConfig().getDouble("FireBallJump.radius");
        List nearbyEntities = (List)l.getWorld().getNearbyEntities(l, radius, radius, radius);
        if (!Main.plugin.getAddonsConfig().getBoolean("Addons.FireballJump")) {
            return;
        }
        if (e.getEntityType() == EntityType.FIREBALL) {
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof LivingEntity)) continue;
                this.pushAway((LivingEntity)entity, l, e);
            }
        }
    }

    void pushAway(LivingEntity player, Location fbl, EntityExplodeEvent e) {
        Main plugin = Main.getInstance();
        Location loc = player.getLocation();
        double distance = e.getYield() * 16.0f;
        distance *= 1.0;
        double hf = plugin.getConfig().getDouble("FireBallJump.height-force") / 2.0;
        double rf = plugin.getConfig().getDouble("FireBallJump.radius-force") / 2.0;
        player.setVelocity(fbl.toVector().subtract(loc.toVector()).normalize().multiply(-1.0 * rf).setY(hf));
        if (player instanceof Player) {
            EntityDamageEvent DamageEvent = new EntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, distance - loc.distance(player.getLocation()));
            Bukkit.getPluginManager().callEvent((Event)DamageEvent);
            if (!DamageEvent.isCancelled()) {
                player.damage(DamageEvent.getFinalDamage());
            }
        }
    }
}

