/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.messagehider.version;

import com.google.gson.JsonSyntaxException;
import de.rapha149.messagehider.version.MHPlayer;
import de.rapha149.messagehider.version.MessageType;
import de.rapha149.messagehider.version.Replacement;
import de.rapha149.messagehider.version.Text;
import de.rapha149.messagehider.version.VersionWrapper;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class Wrapper1_19_R1
implements VersionWrapper {
    private static final Field PLAYER_ADVENTURE_FIELD;
    private static final Field SYSTEM_ADVENTURE_FIELD;

    @Override
    public Class<?> getJsonSyntaxException() {
        return JsonSyntaxException.class;
    }

    @Override
    public ChannelPipeline getPipeline(Player player) {
        return ((CraftPlayer)player).getHandle().b.b.m.pipeline();
    }

    @Override
    public List<Class<?>> getClasses() {
        return List.of(ClientboundPlayerChatPacket.class, ClientboundSystemChatPacket.class);
    }

    @Override
    public Text getText(Object obj) {
        if (obj instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket packet = (ClientboundPlayerChatPacket)obj;
            if (PLAYER_ADVENTURE_FIELD != null) {
                try {
                    Object adventure = PLAYER_ADVENTURE_FIELD.get(packet);
                    if (adventure != null) {
                        return this.getTextFromAdventure(adventure);
                    }
                }
                catch (IllegalAccessException adventure) {
                    // empty catch block
                }
            }
            IChatBaseComponent component = packet.d().orElse(packet.c());
            return new Text(IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)component), component.getString());
        }
        if (obj instanceof ClientboundSystemChatPacket) {
            ClientboundSystemChatPacket packet = (ClientboundSystemChatPacket)obj;
            if (SYSTEM_ADVENTURE_FIELD != null) {
                try {
                    Object adventure = SYSTEM_ADVENTURE_FIELD.get(packet);
                    if (adventure != null) {
                        return this.getTextFromAdventure(adventure);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return new Text(packet.content(), new TextComponent(ComponentSerializer.parse((String)packet.content())).toPlainText());
        }
        throw new IllegalArgumentException("Packet is not of type ClientboundPlayerChatPacket or ClientboundSystemChatPacket");
    }

    @Override
    public MHPlayer getSender(Object obj) {
        if (obj instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket packet = (ClientboundPlayerChatPacket)obj;
            return new MHPlayer(packet.f().a(), packet.f().b().getString());
        }
        if (obj instanceof ClientboundSystemChatPacket) {
            return null;
        }
        throw new IllegalArgumentException("Packet is not of type ClientboundPlayerChatPacket or ClientboundSystemChatPacket");
    }

    @Override
    public MessageType getMessageType(Object obj) {
        if (obj instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket packet = (ClientboundPlayerChatPacket)obj;
            return MessageType.getById(packet.e());
        }
        if (obj instanceof ClientboundSystemChatPacket) {
            ClientboundSystemChatPacket packet = (ClientboundSystemChatPacket)obj;
            return MessageType.getById(packet.c());
        }
        throw new IllegalArgumentException("Packet is not of type ClientboundPlayerChatPacket or ClientboundSystemChatPacket");
    }

    @Override
    public Object replaceText(Object obj, Replacement replacement) {
        Optional<Integer> type;
        Optional<Integer> optional = type = replacement.type != null ? Optional.of(replacement.type.id) : Optional.empty();
        if (obj instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket packet = (ClientboundPlayerChatPacket)obj;
            if (replacement.systemMessage) {
                return new ClientboundSystemChatPacket(ComponentSerializer.parse((String)replacement.text), type.orElse(packet.e()).intValue());
            }
            return new ClientboundPlayerChatPacket(packet.c(), Optional.of(IChatBaseComponent.ChatSerializer.a((String)replacement.text)), type.orElse(packet.e()).intValue(), packet.f(), packet.g(), packet.h());
        }
        if (obj instanceof ClientboundSystemChatPacket) {
            ClientboundSystemChatPacket packet = (ClientboundSystemChatPacket)obj;
            return new ClientboundSystemChatPacket(ComponentSerializer.parse((String)replacement.text), type.orElse(packet.c()).intValue());
        }
        throw new IllegalArgumentException("Packet is not of type ClientboundPlayerChatPacket or ClientboundSystemChatPacket");
    }

    static {
        Field adventureField;
        try {
            adventureField = ClientboundPlayerChatPacket.class.getDeclaredField("adventure$message");
            adventureField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            adventureField = null;
        }
        PLAYER_ADVENTURE_FIELD = adventureField;
        try {
            adventureField = ClientboundSystemChatPacket.class.getDeclaredField("adventure$content");
            adventureField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            adventureField = null;
        }
        SYSTEM_ADVENTURE_FIELD = adventureField;
    }
}

