/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.messagehider.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import de.rapha149.messagehider.Placeholders;
import de.rapha149.messagehider.util.Config;
import de.rapha149.messagehider.version.MHPlayer;
import de.rapha149.messagehider.version.MessageType;
import de.rapha149.messagehider.version.Replacement;
import de.rapha149.messagehider.version.VersionWrapper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.json.JSONObject;

public class Util {
    public static final UUID ZERO_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static VersionWrapper WRAPPER;
    public static String PREFIX;

    public static String replaceGroups(String input, List<String> groups) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = Pattern.compile("(?<!\\$)\\$(\\d)").matcher(input);
        int current = 0;
        while (matcher.find()) {
            sb.append(input, current, matcher.start());
            current = matcher.end();
            int group = Integer.parseInt(matcher.group(1));
            sb.append(group < groups.size() ? groups.get(group) : matcher.group());
        }
        return sb + input.substring(current);
    }

    public static String formatReplacementString(String replacement) {
        if (replacement == null) {
            return null;
        }
        String colorized = ChatColor.translateAlternateColorCodes((char)'&', (String)replacement);
        if (colorized.startsWith("{") && colorized.endsWith("}") || colorized.startsWith("[") && colorized.endsWith("]")) {
            return colorized;
        }
        JSONObject json = new JSONObject();
        json.put("text", colorized);
        return json.toString();
    }

    private static String[] getReplacementForCommand(String replacement, List<String> regexGroups) {
        String colorized = ChatColor.translateAlternateColorCodes((char)'&', (String)replacement);
        if (regexGroups != null) {
            colorized = Util.replaceGroups(colorized, regexGroups);
        }
        if (colorized.startsWith("{") && colorized.endsWith("}")) {
            try {
                String plain = new TextComponent(ComponentSerializer.parse((String)colorized)).toPlainText();
                return new String[]{plain, colorized};
            }
            catch (Exception e) {
                if (e.getClass() == WRAPPER.getJsonSyntaxException()) {
                    e.printStackTrace();
                    return null;
                }
                throw e;
            }
        }
        return new String[]{colorized, colorized};
    }

    public static FilterCheckResult checkFilters(String plain, String json, MessageType type, MHPlayer sender, MHPlayer receiver, String ... filterIds) {
        int ignored = 0;
        int filtered = 0;
        ArrayList<String> filteredIds = new ArrayList<String>();
        List<String> ids = Arrays.asList(filterIds);
        ArrayList<String> usedIds = new ArrayList<String>();
        boolean hidden = false;
        Replacement replacement = null;
        ArrayList<Config.FilterData.CommandData> commands = new ArrayList<Config.FilterData.CommandData>();
        for (Config.FilterData filter : Config.getFilters()) {
            String representation;
            String name;
            if (filter.message == null) continue;
            String id = filter.id;
            if (!ids.isEmpty() && (id == null || !ids.contains(id))) continue;
            usedIds.add(id);
            Config.FilterData.TargetsData players = filter.targets;
            if (sender != null) {
                name = sender.name;
                representation = sender.representation;
                if (!Bukkit.getOnlineMode() ? !players.senders.isEmpty() && !players.senders.contains(representation) || players.excludedSenders.contains(representation) : !players.senders.isEmpty() && !players.senders.contains(representation) && !players.senders.contains(name) || players.excludedSenders.contains(representation) || players.excludedSenders.contains(name)) continue;
            }
            if (receiver != null) {
                name = receiver.name;
                representation = receiver.representation;
                if (!Bukkit.getOnlineMode() ? !players.receivers.isEmpty() && !players.receivers.contains(representation) || players.excludedReceivers.contains(representation) : !players.receivers.isEmpty() && !players.receivers.contains(representation) && !players.receivers.contains(name) || players.excludedReceivers.contains(representation) || players.excludedReceivers.contains(name)) continue;
                if (sender != null && sender.equals(receiver) && filter.onlyHideForOtherPlayers) continue;
            }
            Config.FilterData.MessageData message = filter.message;
            if (message.type != null && message.type != type) continue;
            String filterMessage = message.text;
            Replacement replace = message.replace;
            boolean ignoreCase = message.ignoreCase;
            boolean regex = message.regex;
            boolean onlyExecuteCommands = filter.onlyExecuteCommands;
            boolean stopAfter = filter.stopAfter;
            List<Config.FilterData.CommandData> cmds = filter.commands.stream().map(Config.FilterData.CommandData::new).collect(Collectors.toList());
            if (message.json.enabled) {
                if (json != null) {
                    JsonResult result = Util.jsonMatches(filterMessage, json, regex, ignoreCase, message.json.jsonPrecisionLevel);
                    if (!result.matches) continue;
                    if (!cmds.isEmpty()) {
                        String[] stringArray;
                        if (replace.text != null) {
                            stringArray = Util.getReplacementForCommand(replace.text, result.groups);
                        } else {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = plain;
                            stringArray = stringArray2;
                            stringArray2[1] = json;
                        }
                        String[] replacements = stringArray;
                        Placeholders.replace(cmds, sender, receiver, plain, json, replacements[0], replacements[1], regex ? result.groups : Arrays.asList(new String[0]));
                        commands.addAll(cmds);
                    }
                    ++filtered;
                    if (id != null) {
                        filteredIds.add(id);
                    }
                    if (!onlyExecuteCommands && !hidden && replacement == null) {
                        if (!replace.enabled) {
                            hidden = true;
                        } else {
                            Replacement replacement2 = replacement = regex ? replace.withText(Util.replaceGroups(replace.text, result.groups), json) : replace;
                        }
                    }
                    if (!stopAfter) continue;
                    break;
                }
                ++ignored;
                continue;
            }
            if (plain != null) {
                if (regex) {
                    Matcher matcher = Pattern.compile(filterMessage, ignoreCase ? 2 : 0).matcher(plain);
                    if (!matcher.matches()) continue;
                    ArrayList<String> groups = new ArrayList<String>();
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        groups.add(matcher.group(i));
                    }
                    if (!cmds.isEmpty()) {
                        String[] stringArray;
                        if (replace.text != null) {
                            stringArray = Util.getReplacementForCommand(replace.text, groups);
                        } else {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = plain;
                            stringArray = stringArray3;
                            stringArray3[1] = json;
                        }
                        String[] replacements = stringArray;
                        Placeholders.replace(cmds, sender, receiver, plain, json, replacements[0], replacements[1], groups);
                        commands.addAll(cmds);
                    }
                    ++filtered;
                    if (id != null) {
                        filteredIds.add(id);
                    }
                    if (!onlyExecuteCommands && !hidden && replacement == null) {
                        if (!replace.enabled) {
                            hidden = true;
                        } else {
                            replacement = replace.withText(Util.replaceGroups(replace.text, groups), json);
                        }
                    }
                    if (!stopAfter) continue;
                    break;
                }
                if (!(ignoreCase ? plain.equalsIgnoreCase(filterMessage) : plain.equals(filterMessage))) continue;
                if (!cmds.isEmpty()) {
                    String[] stringArray;
                    if (replace.text != null) {
                        stringArray = Util.getReplacementForCommand(replace.text, null);
                    } else {
                        String[] stringArray4 = new String[2];
                        stringArray4[0] = plain;
                        stringArray = stringArray4;
                        stringArray4[1] = json;
                    }
                    String[] replacements = stringArray;
                    Placeholders.replace(cmds, sender, receiver, plain, json, replacements[0], replacements[1], Arrays.asList(new String[0]));
                    commands.addAll(cmds);
                }
                ++filtered;
                if (id != null) {
                    filteredIds.add(id);
                }
                if (!onlyExecuteCommands && !hidden && replacement == null) {
                    if (!replace.enabled) {
                        hidden = true;
                    } else {
                        replacement = replace.withFallback(json);
                    }
                }
                if (!stopAfter) continue;
                break;
            }
            ++ignored;
        }
        ArrayList<String> notFoundIds = new ArrayList<String>(ids);
        notFoundIds.removeAll(usedIds);
        return new FilterCheckResult(filtered, filteredIds, ignored, notFoundIds, hidden, replacement, commands);
    }

    public static JsonResult jsonMatches(String json1, String json2, final boolean regex, final boolean ignoreCase, int precisionLevel) {
        final ArrayList<String> groups = regex ? new ArrayList<String>(Arrays.asList(json1)) : null;
        Map<String, Object> map1 = new JSONObject(json1).toMap();
        Map<String, Object> map2 = new JSONObject(json2).toMap();
        MapDifference difference = Maps.difference(Util.flatten(map1), Util.flatten(map2), (Equivalence)new Equivalence<Object>(){

            protected boolean doEquivalent(Object a, Object b) {
                if (a instanceof String && b instanceof String) {
                    Matcher matcher;
                    if (regex && (matcher = Pattern.compile((String)a).matcher((String)b)).matches()) {
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            groups.add(matcher.group(i));
                        }
                        return true;
                    }
                    if (ignoreCase && ((String)a).equalsIgnoreCase((String)b)) {
                        return true;
                    }
                    if (a.equals("<ignore>")) {
                        return true;
                    }
                }
                return a.equals(b);
            }

            protected int doHash(Object o) {
                return o.hashCode();
            }
        });
        if (!difference.entriesDiffering().isEmpty()) {
            return new JsonResult(false);
        }
        switch (precisionLevel) {
            case 3: {
                return new JsonResult(difference.entriesOnlyOnLeft().isEmpty() && difference.entriesOnlyOnRight().isEmpty(), groups);
            }
            case 2: {
                return new JsonResult(difference.entriesOnlyOnLeft().isEmpty() && difference.entriesOnlyOnRight().entrySet().stream().noneMatch(entry -> !(entry.getValue() instanceof Boolean) || (Boolean)entry.getValue() != false), groups);
            }
            case 1: {
                return new JsonResult(difference.entriesOnlyOnLeft().isEmpty(), groups);
            }
            case 0: {
                return new JsonResult(true, groups);
            }
        }
        return new JsonResult(false);
    }

    private static Map<String, Object> flatten(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(Util::flatten).collect(LinkedHashMap::new, (m, e) -> m.put("/" + (String)e.getKey(), e.getValue()), HashMap::putAll);
    }

    private static Stream<Map.Entry<String, Object>> flatten(Map.Entry<String, Object> entry) {
        if (entry == null) {
            return Stream.empty();
        }
        if (entry.getValue() instanceof Map) {
            Map properties = (Map)entry.getValue();
            return properties.entrySet().stream().flatMap(e -> Util.flatten(new AbstractMap.SimpleEntry<String, Object>((String)entry.getKey() + "/" + e.getKey(), e.getValue())));
        }
        if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            return IntStream.range(0, list.size()).mapToObj(i -> new AbstractMap.SimpleEntry((String)entry.getKey() + "/" + i, list.get(i))).flatMap(Util::flatten);
        }
        return Stream.of(entry);
    }

    static {
        PREFIX = "";
    }

    private static class JsonResult {
        private boolean matches;
        private List<String> groups;

        public JsonResult(boolean matches) {
            this.matches = matches;
            this.groups = null;
        }

        private JsonResult(boolean matches, List<String> groups) {
            this.matches = matches;
            this.groups = matches ? groups : null;
        }
    }

    public static class FilterCheckResult {
        private FilterStatus status;
        private int filteredCount;
        private List<String> filteredIds;
        private int ignored;
        List<String> notFoundIds;
        private Replacement replacement;
        private List<Config.FilterData.CommandData> commands;

        private FilterCheckResult(int filteredCount, List<String> filteredIds, int ignored, List<String> notFoundIds, boolean hidden, Replacement replacement, List<Config.FilterData.CommandData> commands) {
            this.status = hidden ? FilterStatus.HIDDEN : (replacement != null ? FilterStatus.REPLACED : FilterStatus.NORMAL);
            this.filteredCount = filteredCount;
            this.filteredIds = filteredIds;
            this.ignored = ignored;
            this.notFoundIds = notFoundIds;
            this.replacement = replacement;
            this.commands = commands;
        }

        public FilterStatus getStatus() {
            return this.status;
        }

        public int getFilteredCount() {
            return this.filteredCount;
        }

        public List<String> getFilteredIds() {
            return this.filteredIds;
        }

        public int getIgnored() {
            return this.ignored;
        }

        public List<String> getNotFoundIds() {
            return this.notFoundIds;
        }

        public Replacement getReplacement() {
            return this.replacement;
        }

        public List<Config.FilterData.CommandData> getCommands() {
            return this.commands;
        }

        public static enum FilterStatus {
            NORMAL,
            HIDDEN,
            REPLACED;

        }
    }
}

