/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.messagehider.util;

import de.rapha149.messagehider.MessageHider;
import de.rapha149.messagehider.util.CustomPropertyUtils;
import de.rapha149.messagehider.util.Presets;
import de.rapha149.messagehider.util.Util;
import de.rapha149.messagehider.version.MessageType;
import de.rapha149.messagehider.version.Replacement;
import de.rapha149.snakeyaml.DumperOptions;
import de.rapha149.snakeyaml.Yaml;
import de.rapha149.snakeyaml.constructor.CustomClassLoaderConstructor;
import de.rapha149.snakeyaml.representer.Representer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.json.JSONException;
import org.json.JSONObject;

public class Config {
    private static final Pattern ALLOWED_CHARS_PATTERN = Pattern.compile("[\\w\\d]+");
    private static final String CONFIG_VERSION = "2.1";
    private static File file;
    private static Yaml yaml;
    private static Config config;
    public boolean checkForUpdates = true;
    private String prefix = "&8[&cMH&8] ";
    public PresetsData presets = new PresetsData();
    private List<FilterData> messageFilters = new ArrayList<FilterData>();
    public transient String translatedPrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.prefix);
    public transient List<FilterData> filters = new ArrayList<FilterData>();

    public static void load() throws IOException {
        Logger logger = MessageHider.getInstance().getLogger();
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Representer representer = new Representer();
        representer.setPropertyUtils(new CustomPropertyUtils());
        yaml = new Yaml(new CustomClassLoaderConstructor(((Object)((Object)MessageHider.getInstance())).getClass().getClassLoader()), representer, options);
        file = new File(MessageHider.getInstance().getDataFolder(), "config.yml");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            String line = br.readLine();
            String content = br.lines().collect(Collectors.joining("\n"));
            if (line != null && line.startsWith("# version=2 ")) {
                line = "# version=2.1 ";
                String indent = String.join((CharSequence)"", Collections.nCopies(options.getIndent(), " "));
                content = content.replaceAll("( +)replacement: (.+)", "$1replace:\n$1" + indent + "enabled: true\n$1" + indent + "text: $2");
            }
            if (line != null && line.startsWith("# version=2.1 ")) {
                config = yaml.loadAs(content, Config.class);
            } else {
                File renamed;
                int number = 0;
                while ((renamed = new File(MessageHider.getInstance().getDataFolder(), "config.yml.old" + (number > 0 ? Integer.valueOf(number) : ""))).exists()) {
                    ++number;
                }
                file.renameTo(renamed);
                config = new Config();
                logger.severe("Your config was outdated so it got regenerated. The old config was renamed to \"" + renamed.getName() + "\". Please recreate custom filters by using \"/messagehider create\".");
            }
        } else {
            config = new Config();
        }
        Config.save();
        Util.PREFIX = Config.config.translatedPrefix;
        Iterator<FilterData> iterator = Config.config.filters.iterator();
        while (iterator.hasNext()) {
            String text;
            String filterSpecification;
            FilterData filter2 = iterator.next();
            String id = filter2.id;
            if (id != null && !ALLOWED_CHARS_PATTERN.matcher(id).matches()) {
                logger.warning("Filter ids must only contain letters, numbers and underscores. (Wrong id: \"" + id + "\")");
                iterator.remove();
                continue;
            }
            String string = filterSpecification = id != null ? "the filter " + id : "a filter";
            if (filter2.message.json.enabled) {
                try {
                    new JSONObject(filter2.message.text);
                }
                catch (JSONException e) {
                    logger.warning("You got a json error in '" + filter2.message + "' (Message of " + filterSpecification + ")");
                    iterator.remove();
                    continue;
                }
            }
            if (filter2.message.replace.text == null || !(text = filter2.message.replace.text).startsWith("{") || !text.endsWith("}")) continue;
            try {
                new JSONObject(text);
            }
            catch (JSONException e) {
                logger.warning("You got a json error in '" + filter2.message + "' (Replacement of " + filterSpecification + ")");
                iterator.remove();
            }
        }
        ArrayList ids = new ArrayList();
        Config.getFilters().forEach(filter -> {
            if (filter.id != null) {
                if (!ids.contains(filter.id)) {
                    ids.add(filter.id);
                } else {
                    logger.warning("You have duplicate filter ids: \"" + filter.id + "\"");
                }
            }
        });
        PresetsData presets = Config.config.presets;
        if (presets.gamemodeChange && Presets.GAMEMODE_CHANGE == null) {
            logger.warning("You enabled the preset 'gamemodeChange' but it is not suitable for this server version.");
        }
        if (presets.onlySelfCommands && Presets.ONLY_SELF_COMMANDS == null) {
            logger.warning("You enabled the preset 'onlySelfCommands' but it is not suitable for this server version.");
        }
        if (presets.consoleCommands && Presets.CONSOLE_COMMANDS == null) {
            logger.warning("You enabled the preset 'consoleCommands' but it is not suitable for this server version.");
        }
    }

    public static void save() throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            writer.write("# version=2.1 DO NOT CHANGE THIS LINE\n" + yaml.dumpAsMap(config).replaceAll("\\[\\n\\s+\\]", "[]"));
        }
    }

    public static Config get() {
        return config;
    }

    public static List<FilterData> getFilters() {
        ArrayList<FilterData> filters = new ArrayList<FilterData>(Config.config.filters);
        PresetsData presets = Config.config.presets;
        if (presets.idleTimeout) {
            filters.add(Presets.IDLE_TIMEOUT);
        }
        if (presets.gamemodeChange && Presets.GAMEMODE_CHANGE != null) {
            filters.add(Presets.GAMEMODE_CHANGE);
        }
        if (presets.onlySelfCommands && Presets.ONLY_SELF_COMMANDS != null) {
            filters.add(Presets.ONLY_SELF_COMMANDS);
        }
        if (presets.consoleCommands && Presets.CONSOLE_COMMANDS != null) {
            filters.add(Presets.CONSOLE_COMMANDS);
        }
        return filters;
    }

    public static List<FilterData> getCustomFiltersByIds(List<String> ids) {
        return Config.config.filters.stream().filter(filter -> filter.id != null && ids.contains(filter.id)).collect(Collectors.toList());
    }

    public static void addFilter(FilterData filter) throws IOException {
        Config.config.messageFilters.add(filter);
        Config.config.filters.add(filter);
        Config.save();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.translatedPrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
    }

    public List<FilterData> getMessageFilters() {
        return this.messageFilters;
    }

    public void setMessageFilters(List<FilterData> messageFilters) {
        this.messageFilters = messageFilters;
        this.filters = new ArrayList<FilterData>(messageFilters);
        this.filters.sort((f1, f2) -> {
            if (f1.priority == null && f2.priority == null) {
                return 0;
            }
            if (f1.priority != null && f2.priority == null) {
                return -1;
            }
            if (f1.priority == null && f2.priority != null) {
                return 1;
            }
            return f1.priority.compareTo(f2.priority);
        });
    }

    public static class PresetsData {
        public boolean idleTimeout = false;
        public boolean gamemodeChange = false;
        public boolean onlySelfCommands = false;
        public boolean consoleCommands = false;
    }

    public static class FilterData {
        public String id;
        public MessageData message;
        public boolean onlyHideForOtherPlayers;
        public boolean onlyExecuteCommands;
        public boolean stopAfter;
        public Integer priority;
        public List<CommandData> commands;
        public TargetsData targets;

        public FilterData() {
            this.id = null;
            this.message = new MessageData();
            this.onlyHideForOtherPlayers = false;
            this.onlyExecuteCommands = false;
            this.stopAfter = false;
            this.priority = null;
            this.commands = new ArrayList<CommandData>();
            this.targets = new TargetsData();
        }

        public FilterData(String id, MessageData message, boolean onlyHideForOtherPlayers, boolean onlyExecuteCommands, boolean stopAfter, Integer priority, List<CommandData> commands) {
            this.id = id;
            this.message = message;
            this.onlyHideForOtherPlayers = onlyHideForOtherPlayers;
            this.onlyExecuteCommands = onlyExecuteCommands;
            this.stopAfter = stopAfter;
            this.priority = priority;
            this.commands = commands;
            this.targets = new TargetsData();
        }

        public FilterData(String id, MessageData message, boolean onlyHideForOtherPlayers, boolean onlyExecuteCommands, boolean stopAfter, Integer priority, List<CommandData> commands, TargetsData targets) {
            this.id = id;
            this.message = message;
            this.onlyHideForOtherPlayers = onlyHideForOtherPlayers;
            this.onlyExecuteCommands = onlyExecuteCommands;
            this.stopAfter = stopAfter;
            this.priority = priority;
            this.commands = commands;
            this.targets = targets;
        }

        public static class MessageData {
            public String text;
            public Replacement replace;
            public boolean ignoreCase;
            public MessageType type;
            public boolean regex;
            public JsonData json;

            public MessageData() {
                this.text = "";
                this.replace = new Replacement();
                this.ignoreCase = false;
                this.type = null;
                this.regex = false;
                this.json = new JsonData();
            }

            public MessageData(String text, Replacement replace, boolean ignoreCase, MessageType type, boolean regex, JsonData json) {
                this.text = text;
                this.replace = replace;
                this.ignoreCase = ignoreCase;
                this.type = type;
                this.regex = regex;
                this.json = json;
            }

            public static class JsonData {
                public boolean enabled;
                public int jsonPrecisionLevel;

                public JsonData() {
                    this.enabled = false;
                    this.jsonPrecisionLevel = 2;
                }

                public JsonData(boolean enabled, int jsonPrecisionLevel) {
                    this.enabled = enabled;
                    this.jsonPrecisionLevel = jsonPrecisionLevel;
                }
            }
        }

        public static class TargetsData {
            public List<String> senders;
            public List<String> excludedSenders;
            public List<String> receivers;
            public List<String> excludedReceivers;

            public TargetsData() {
                this.senders = new ArrayList<String>();
                this.excludedSenders = new ArrayList<String>();
                this.receivers = new ArrayList<String>();
                this.excludedReceivers = new ArrayList<String>();
            }

            public TargetsData(List<String> senders, List<String> excludedSenders, List<String> receivers, List<String> excludedReceivers) {
                this.senders = senders;
                this.excludedSenders = excludedSenders;
                this.receivers = receivers;
                this.excludedReceivers = excludedReceivers;
            }
        }

        public static class CommandData {
            public String command = "cmd";
            public CommandType type = CommandType.CONSOLE;
            public float delay = 0.0f;

            public CommandData() {
            }

            public CommandData(CommandData commandData) {
                this.command = commandData.command;
                this.type = commandData.type;
                this.delay = commandData.delay;
            }

            public static enum CommandType {
                CONSOLE,
                PLAYER;

            }
        }
    }
}

