/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.messagehider;

import de.rapha149.messagehider.MessageHider;
import de.rapha149.messagehider.Placeholders;
import de.rapha149.messagehider.util.Config;
import de.rapha149.messagehider.util.Util;
import de.rapha149.messagehider.version.MHPlayer;
import de.rapha149.messagehider.version.MessageType;
import de.rapha149.messagehider.version.Replacement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageHiderCommand
implements CommandExecutor,
TabCompleter {
    private static final SimpleDateFormat format = new SimpleDateFormat("[dd.MM.yy HH:mm:ss]");
    private static Map<UUID, File> logging;

    public MessageHiderCommand(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
        logging = new HashMap<UUID, File>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length >= 1 && args[0].toLowerCase().matches("reload|log|create|createcommand|check|run")) {
            switch (args[0].toLowerCase()) {
                case "reload": {
                    if (sender.hasPermission("messagehider.reload")) {
                        try {
                            Config.load();
                            sender.sendMessage(Util.PREFIX + "\u00a72The config was reloaded.");
                            return true;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            sender.sendMessage(Util.PREFIX + "\u00a7cAn error occurred.");
                        }
                        return true;
                    }
                    sender.sendMessage(Util.PREFIX + "\u00a7cYou don't have enough permissions for this.");
                    return true;
                }
                case "log": {
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        if (player.hasPermission("messagehider.log")) {
                            if (args.length >= 2 && args[1].toLowerCase().matches("start|stop")) {
                                UUID uuid = player.getUniqueId();
                                switch (args[1].toLowerCase()) {
                                    case "start": {
                                        if (!logging.containsKey(uuid)) {
                                            File file = new File(MessageHider.getInstance().getDataFolder(), "logs/" + player.getName() + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".log");
                                            if (!file.getParentFile().exists()) {
                                                file.getParentFile().mkdirs();
                                            }
                                            logging.put(uuid, file);
                                            MessageHiderCommand.write(uuid, format.format(new Date()) + "\nStarted logging");
                                            player.sendMessage(Util.PREFIX + "\u00a7aYou are now logging messages sent to you.");
                                            player.spigot().sendMessage(new ComponentBuilder("\u00a72Use ").append("\u00a77/mh log stop").event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/mh log stop")).append(" \u00a72to stop logging.").reset().create());
                                            return true;
                                        }
                                        player.sendMessage(Util.PREFIX + "\u00a76You are already logging messages.");
                                        return true;
                                    }
                                    case "stop": {
                                        if (logging.containsKey(uuid)) {
                                            player.sendMessage(Util.PREFIX + "\u00a7bStopped logging.\n\u00a73Logged messages are located in \u00a77" + logging.get(uuid).getParentFile().getPath() + "\u00a73.");
                                            Bukkit.getScheduler().runTaskLater((Plugin)MessageHider.getInstance(), () -> {
                                                MessageHiderCommand.write(uuid, format.format(new Date()) + "\nStopped logging\n");
                                                logging.remove(uuid);
                                            }, 20L);
                                            return true;
                                        }
                                        player.sendMessage(Util.PREFIX + "\u00a76You weren't logging messages.");
                                    }
                                }
                                return true;
                            }
                            player.sendMessage(Util.PREFIX + "\u00a7cPlease use \u00a77/" + alias + " log <start|stop>\u00a7c.");
                            return true;
                        }
                        player.sendMessage(Util.PREFIX + "\u00a7cYou don't have enough permissions for this.");
                        return true;
                    }
                    sender.sendMessage(Util.PREFIX + "\u00a7cOnly possible for players.");
                    return true;
                }
                case "create": {
                    if (sender.hasPermission("messagehider.create")) {
                        try {
                            Config.addFilter(new Config.FilterData());
                            sender.sendMessage(Util.PREFIX + "\u00a72An empty filter was created.");
                            return true;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            sender.sendMessage(Util.PREFIX + "\u00a7cAn error occurred.");
                        }
                        return true;
                    }
                    sender.sendMessage(Util.PREFIX + "\u00a7cYou don't have enough permissions for this.");
                    return true;
                }
                case "createcommand": {
                    if (sender.hasPermission("messagehider.createcommand")) {
                        if (args.length >= 2) {
                            List<Config.FilterData> filters = Config.getCustomFiltersByIds(Arrays.asList(args[1]));
                            if (!filters.isEmpty()) {
                                try {
                                    filters.forEach(filter -> filter.commands.add(new Config.FilterData.CommandData()));
                                    Config.save();
                                    sender.sendMessage(Util.PREFIX + "\u00a72A command for the filter" + (filters.size() != 1 ? "s" : "") + " \u00a7a" + args[1] + " \u00a72was created.");
                                    return true;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    sender.sendMessage(Util.PREFIX + "\u00a7cAn error occured.");
                                }
                                return true;
                            }
                            sender.sendMessage(Util.PREFIX + "\u00a7cUnknown filter.");
                            return true;
                        }
                        sender.sendMessage(Util.PREFIX + "\u00a7cPlease use \u00a77/" + alias + " createcommand <Filter>\u00a7c.");
                        return true;
                    }
                    sender.sendMessage(Util.PREFIX + "\u00a7cYou don't have enough permissions for this.");
                    return true;
                }
                case "check": {
                    if (sender.hasPermission("messagehider.check")) {
                        if (args.length >= 4 && args[1].toLowerCase().matches("json|plain")) {
                            String replaceText;
                            boolean json = args[1].equalsIgnoreCase("json");
                            String[] filterIds = args[2].equals("-") ? new String[]{} : args[2].split(",");
                            String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
                            if (json) {
                                try {
                                    new JSONObject(message);
                                }
                                catch (JSONException e) {
                                    sender.sendMessage(Util.PREFIX + "\u00a7cYour json is not valid.");
                                    return true;
                                }
                            }
                            Util.FilterCheckResult result = Util.checkFilters(json ? null : message, json ? message : null, null, null, null, filterIds);
                            boolean player = sender instanceof Player;
                            StringBuilder sb = new StringBuilder(Util.PREFIX + "\u00a72Result:");
                            if (!result.getNotFoundIds().isEmpty()) {
                                sb.append("\n\u00a77  - \u00a76These filter ids were not found: \u00a7e" + String.join((CharSequence)"\u00a78, \u00a7e", result.getNotFoundIds()));
                            }
                            if (result.getIgnored() > 0) {
                                sb.append("\n\u00a77  - \u00a7e" + result.getIgnored() + " \u00a76filter" + (result.getIgnored() == 1 ? " was" : "s were") + " ignored because they were in " + (json ? "plain" : "json") + " text.");
                            }
                            sb.append("\n\u00a77  - \u00a7bThe message would ");
                            if (result.getStatus() == Util.FilterCheckResult.FilterStatus.HIDDEN) {
                                sb.append("be \u00a74hidden\u00a77.");
                            } else if (result.getStatus() == Util.FilterCheckResult.FilterStatus.REPLACED) {
                                sb.append("be \u00a7ereplaced\u00a77.");
                            } else {
                                sb.append("remain \u00a7anormal\u00a77.");
                            }
                            if (!result.getFilteredIds().isEmpty()) {
                                sb.append("\n\u00a77  - \u00a7bThese filters that would have cancelled the message: \u00a73" + String.join((CharSequence)"\u00a78, \u00a73", result.getFilteredIds()));
                            } else {
                                sb.append("\n\u00a77  - \u00a7bNo filters with ids cancelled the message.");
                            }
                            sb.append("\n\u00a77  - \u00a73" + result.getFilteredCount() + " \u00a7btotal filter" + (result.getFilteredCount() == 1 ? "" : "s") + " cancelled the message. (Including filters without ids)");
                            Replacement replacement = result.getReplacement();
                            if (result.getStatus() == Util.FilterCheckResult.FilterStatus.REPLACED) {
                                sb.append("\n\u00a77  - \u00a7bThe message would be replaced by: (Type: " + (Object)((Object)replacement.type) + ")" + (player ? "" : "\n\u00a7f    " + replacement.text));
                            }
                            if (!result.getCommands().isEmpty() && !player) {
                                sb.append("\n\u00a77  - \u00a7bThe following commands would be executed:\n\u00a7f    /" + result.getCommands().stream().map(cmd -> (cmd.type == Config.FilterData.CommandData.CommandType.CONSOLE ? "[CONSOLE] /" : "[PLAYER] /") + cmd.command).collect(Collectors.joining("\n\u00a7f     ")));
                            }
                            sender.sendMessage(sb.toString());
                            if (result.getStatus() == Util.FilterCheckResult.FilterStatus.REPLACED && player && (replaceText = Util.formatReplacementString(replacement.text)) != null) {
                                ((Player)sender).spigot().sendMessage(ComponentSerializer.parse((String)replaceText));
                            }
                            if (result.getCommands().isEmpty() || !player) return true;
                            sender.sendMessage("\u00a77  - \u00a7bThe following commands would be executed:\n\u00a7f/" + result.getCommands().stream().map(cmd -> (cmd.type == Config.FilterData.CommandData.CommandType.CONSOLE ? "[CONSOLE] /" : "[PLAYER] /") + cmd.command).collect(Collectors.joining("\n\u00a7f")));
                            return true;
                        }
                        sender.sendMessage(Util.PREFIX + "\u00a7cPlease use \u00a77/" + alias + " check <json|plain> <Filter ids> <Message>\u00a7c.");
                        return true;
                    }
                    sender.sendMessage(Util.PREFIX + "\u00a7cYou don't have enough permissions for this.");
                    return true;
                }
                case "run": {
                    if (sender.hasPermission("messagehider.run")) {
                        boolean isPlayer = sender instanceof Player;
                        if (args.length >= (isPlayer ? 2 : 3)) {
                            List<Config.FilterData> filters = Config.getCustomFiltersByIds(Arrays.asList(args[1].split(",")));
                            if (!filters.isEmpty()) {
                                Player player1;
                                Player player;
                                if (args.length >= 3) {
                                    player = Bukkit.getPlayerExact((String)args[2]);
                                    if (player == null) {
                                        sender.sendMessage(Util.PREFIX + "\u00a7cUnknown player.");
                                        return true;
                                    }
                                } else {
                                    player = (Player)sender;
                                }
                                if (args.length >= 4) {
                                    player1 = Bukkit.getPlayerExact((String)args[3]);
                                    if (player1 == null) {
                                        player1.sendMessage(Util.PREFIX + "\u00a7cUnknown sender.");
                                        return true;
                                    }
                                } else {
                                    player1 = null;
                                }
                                int commandCount = 0;
                                for (Config.FilterData filter2 : filters) {
                                    ArrayList<Config.FilterData.CommandData> commands = new ArrayList<Config.FilterData.CommandData>(filter2.commands);
                                    commandCount += commands.size();
                                    Placeholders.replace(commands, new MHPlayer(player.getUniqueId()), player1 != null ? new MHPlayer(player1.getUniqueId()) : null, "", "", "", "", Arrays.asList(new String[0]));
                                    commands.forEach(cmd -> Bukkit.getScheduler().runTaskLater((Plugin)MessageHider.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)(cmd.type == Config.FilterData.CommandData.CommandType.CONSOLE ? Bukkit.getConsoleSender() : player), (String)cmd.command), (long)((int)(cmd.delay * 20.0f))));
                                }
                                sender.sendMessage(Util.PREFIX + "\u00a72" + filters.size() + " filter" + (filters.size() != 1 ? "s" : "") + " \u00a7aand \u00a72" + commandCount + " command" + (commandCount != 1 ? "s" : "") + " \u00a7aare being executed" + (player != sender ? " from \u00a72" + player.getName() + "\u00a7a" : "") + ".");
                                return true;
                            }
                            sender.sendMessage(Util.PREFIX + "\u00a7cUnknown filter id.");
                            return true;
                        }
                        sender.sendMessage(Util.PREFIX + "\u00a7cPlease use \u00a77/" + alias + " run <Filters> " + (isPlayer ? "[Player]" : "<Player>") + " [Sender]\u00a7c.");
                        return true;
                    }
                    sender.sendMessage(Util.PREFIX + "\u00a7cYou don't have enough permissions for this.");
                }
            }
            return true;
        }
        sender.sendMessage(Util.PREFIX + "\u00a7cPlease use \u00a77/" + alias + " <reload|log|create|createcommand|check>\u00a7c.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        int index;
        List ids;
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("messagehider.reload")) {
                list.add("reload");
            }
            if (sender.hasPermission("messagehider.log")) {
                list.add("log");
            }
            if (sender.hasPermission("messagehider.create")) {
                list.add("create");
            }
            if (sender.hasPermission("messagehider.createcommand")) {
                list.add("createcommand");
            }
            if (sender.hasPermission("messagehider.check")) {
                list.add("check");
            }
            if (sender.hasPermission("messagehider.run")) {
                list.add("run");
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("log") && sender.hasPermission("messagehider.log")) {
                list.addAll(Arrays.asList("start", "stop"));
            }
            if (args[0].equalsIgnoreCase("check") && sender.hasPermission("messagehider.check")) {
                list.addAll(Arrays.asList("json", "plain"));
            }
            if (args[0].equalsIgnoreCase("createcommand") && sender.hasPermission("messagehider.createcommand")) {
                Config.get().filters.stream().map(filter -> filter.id).filter(Objects::nonNull).distinct().forEach(list::add);
            }
            if (args[0].equalsIgnoreCase("run") && sender.hasPermission("messagehider.run")) {
                ids = Config.getFilters().stream().map(filter -> filter.id).filter(Objects::nonNull).collect(Collectors.toList());
                if (ids.contains(args[1].substring((index = args[1].lastIndexOf(44)) + 1))) {
                    list.add(args[1] + ",");
                } else {
                    String input = args[1].substring(0, index == -1 ? 0 : index);
                    Config.getFilters().stream().map(filter -> filter.id).filter(Objects::nonNull).map(id -> input + (input.isEmpty() ? "" : ",") + id).forEach(list::add);
                }
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("check") && sender.hasPermission("messagehider.check")) {
                if (args[2].isEmpty() || args[2].equals("-")) {
                    list.add("-");
                }
                if ((ids = Config.getFilters().stream().map(filter -> filter.id).filter(Objects::nonNull).collect(Collectors.toList())).contains(args[2].substring((index = args[2].lastIndexOf(44)) + 1))) {
                    list.add(args[2] + ",");
                } else {
                    String input = args[2].substring(0, index == -1 ? 0 : index);
                    Config.getFilters().stream().map(filter -> filter.id).filter(Objects::nonNull).map(id -> input + (input.isEmpty() ? "" : ",") + id).forEach(list::add);
                }
            }
            if (args[0].equalsIgnoreCase("run") && sender.hasPermission("messagehider.run")) {
                Bukkit.getOnlinePlayers().forEach(player -> list.add(player.getName()));
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("run") && sender.hasPermission("messagehider.run")) {
            Bukkit.getOnlinePlayers().forEach(player -> list.add(player.getName()));
        }
        if (list != null) {
            String arg = args[args.length - 1].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            list.stream().filter(s -> s.toLowerCase().startsWith(arg)).forEach(completions::add);
            return completions;
        }
        return Arrays.asList(new String[0]);
    }

    public static void log(MHPlayer player, MHPlayer sender, String plain, String json, MessageType type, Util.FilterCheckResult result) {
        StringBuilder sb = new StringBuilder(format.format(new Date()));
        if (result.getStatus() == Util.FilterCheckResult.FilterStatus.HIDDEN) {
            sb.append(" (Hidden)");
        }
        if (result.getStatus() == Util.FilterCheckResult.FilterStatus.REPLACED) {
            sb.append(" (Replaced)");
        }
        if (sender != null) {
            sb.append("\nSent from: " + sender.representation);
        }
        sb.append("\nType: " + (Object)((Object)type) + "\nPlain: " + plain + "\nJSON: " + json);
        Replacement replacement = result.getReplacement();
        if (replacement != null) {
            sb.append("\nReplaced by: " + Optional.ofNullable(replacement.text).orElse(json) + "\n   Type: " + (Object)((Object)replacement.type));
        }
        MessageHiderCommand.write(player.uuid, sb.toString());
    }

    private static void write(UUID uuid, String str) {
        if (logging.containsKey(uuid)) {
            try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(logging.get(uuid), true));){
                writer.write(str + "\n\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

