/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.messagehider;

import de.rapha149.messagehider.Events;
import de.rapha149.messagehider.MessageHiderCommand;
import de.rapha149.messagehider.Metrics;
import de.rapha149.messagehider.Placeholders;
import de.rapha149.messagehider.Updates;
import de.rapha149.messagehider.util.Config;
import de.rapha149.messagehider.util.Util;
import de.rapha149.messagehider.version.VersionWrapper;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageHider
extends JavaPlugin {
    private static MessageHider instance;
    private Events events;
    public boolean placeholderAPISupport;

    public void onEnable() {
        instance = this;
        String nmsVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1);
        try {
            Util.WRAPPER = (VersionWrapper)Class.forName(VersionWrapper.class.getPackage().getName() + ".Wrapper" + nmsVersion).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Failed to load support for server version " + nmsVersion, e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("MessageHider does not support the server version \"" + nmsVersion + "\"", e);
        }
        PluginManager manager = this.getServer().getPluginManager();
        try {
            Config.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            manager.disablePlugin((Plugin)this);
            return;
        }
        Metrics metrics = new Metrics(this, 11112);
        metrics.addCustomChart(new Metrics.SingleLineChart("idle_timeout", () -> Config.get().presets.idleTimeout ? 1 : 0));
        metrics.addCustomChart(new Metrics.SingleLineChart("gamemode_change", () -> Config.get().presets.gamemodeChange ? 1 : 0));
        metrics.addCustomChart(new Metrics.SingleLineChart("only_self_commands", () -> Config.get().presets.onlySelfCommands ? 1 : 0));
        metrics.addCustomChart(new Metrics.SingleLineChart("console_commands", () -> Config.get().presets.consoleCommands ? 1 : 0));
        metrics.addCustomChart(new Metrics.SingleLineChart("custom_filters_total", () -> Config.get().filters.size()));
        metrics.addCustomChart(new Metrics.SimplePie("custom_filters_per_server", () -> String.valueOf(Config.get().filters.size())));
        new MessageHiderCommand(this.getCommand("messagehider"));
        this.events = new Events();
        manager.registerEvents((Listener)this.events, (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderAPISupport = true;
            Placeholders.registerPlaceholderExpansion();
            this.getLogger().info("PlaceholderAPI support was enabled.");
        }
        if (Config.get().checkForUpdates) {
            String version = Updates.getAvailableVersion(true);
            if (version == null) {
                this.getLogger().info("Your version of this plugin is up to date!");
            } else {
                this.getLogger().warning("There's a new version available for this plugin: " + version + ". Download urls:\n- SpigotMC: " + "https://www.spigotmc.org/resources/messagehider.91661" + "\n- BukkitDev: " + "https://dev.bukkit.org/projects/messagehider" + " (It may take a few hours until the update is approved there).");
            }
        }
        this.getLogger().info("Plugin successfully enabled!");
    }

    public void onDisable() {
        this.events.removeHandlers();
        this.getLogger().info("Plugin disabled.");
    }

    public static MessageHider getInstance() {
        return instance;
    }
}

