/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.messagehider;

import de.rapha149.messagehider.MessageHider;
import de.rapha149.messagehider.MessageHiderCommand;
import de.rapha149.messagehider.Updates;
import de.rapha149.messagehider.util.Config;
import de.rapha149.messagehider.util.Util;
import de.rapha149.messagehider.version.MHPlayer;
import de.rapha149.messagehider.version.MessageType;
import de.rapha149.messagehider.version.Text;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class Events
implements Listener {
    public Events() {
        Bukkit.getOnlinePlayers().forEach(this::addHandler);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        String version;
        Player player = event.getPlayer();
        this.addHandler(player);
        if (player.isOp() && Config.get().checkForUpdates && (version = Updates.getAvailableVersion()) != null) {
            player.sendMessage(Util.PREFIX + "\u00a76There's a new version available for this plugin: \u00a77" + version);
            player.spigot().sendMessage(new ComponentBuilder(Util.PREFIX + "\u00a76You can download it from ").append("\u00a73SpigotMC").event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/messagehider.91661")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a73Click here to view the plugin on SpigotMC.").create())).append(" \u00a76or ").reset().append("\u00a73BukkitDev").event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://dev.bukkit.org/projects/messagehider")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a73Click here to view the plugin on BukkitDev.\n\u00a77It may take a few hours until the update is approved there.").create())).append("\u00a76.").create());
        }
    }

    public void reloadHandlers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            try {
                Util.WRAPPER.getPipeline((Player)player).remove("MessageHider");
                this.addHandler((Player)player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void removeHandlers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            try {
                Util.WRAPPER.getPipeline((Player)player).remove("MessageHider");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void addHandler(final Player player) {
        ChannelPipeline pipeline;
        try {
            pipeline = Util.WRAPPER.getPipeline(player);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        pipeline.addAfter("packet_handler", "MessageHider", (ChannelHandler)new ChannelDuplexHandler(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                try {
                    if (Util.WRAPPER.getClasses().contains(msg.getClass())) {
                        Text text = Util.WRAPPER.getText(msg);
                        String json = text.json;
                        String plain = text.plain;
                        MessageType type = Util.WRAPPER.getMessageType(msg);
                        MHPlayer sender = Util.WRAPPER.getSender(msg);
                        MHPlayer receiver = new MHPlayer(player.getUniqueId());
                        Util.FilterCheckResult result = Util.checkFilters(plain, json, type, sender, receiver, new String[0]);
                        MessageHiderCommand.log(receiver, sender, plain, json, type, result);
                        if (!result.getCommands().isEmpty()) {
                            result.getCommands().forEach(command -> Bukkit.getScheduler().runTaskLater((Plugin)MessageHider.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)(command.type == Config.FilterData.CommandData.CommandType.CONSOLE ? Bukkit.getConsoleSender() : player), (String)command.command), (long)((int)(command.delay * 20.0f))));
                        }
                        if (result.getStatus() == Util.FilterCheckResult.FilterStatus.REPLACED) {
                            String replaceText = Util.formatReplacementString(result.getReplacement().text);
                            msg = Util.WRAPPER.replaceText(msg, result.getReplacement().withText(replaceText, json));
                        } else if (result.getStatus() == Util.FilterCheckResult.FilterStatus.HIDDEN) {
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                super.write(ctx, msg, promise);
            }
        });
    }
}

