/*
 * Decompiled with CFR 0.152.
 */
package me.niel251.SpourmoStaffMode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.niel251.SpourmoStaffMode.Commands;
import me.niel251.SpourmoStaffMode.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Events
implements Listener {
    private Main main;
    static Map<UUID, Boolean> frozen = new HashMap<UUID, Boolean>();
    private static Main plugin = (Main)Main.getPlugin(Main.class);

    public static boolean isFrozen(UUID uuid) {
        if (!frozen.containsKey(uuid)) {
            frozen.put(uuid, false);
            return frozen.get(uuid);
        }
        return frozen.get(uuid);
    }

    public Events(Main main) {
        this.main = main;
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        String prefix = plugin.getConfig().getString("Prefix");
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (Commands.isActive(uuid)) {
            Commands.staffModeDisable(player);
        }
        if (Events.isFrozen(uuid)) {
            Bukkit.getOnlinePlayers().forEach(o -> {
                if (o.hasPermission("staffmode.use")) {
                    o.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7" + player.getName() + " &7has logged out while frozen.")));
                }
            });
        }
    }

    @EventHandler
    public void onPlayerClicks(PlayerInteractEvent event) {
        String prefix = plugin.getConfig().getString("Prefix");
        Player player = event.getPlayer();
        Action action = event.getAction();
        ItemStack item = event.getItem();
        UUID uuid = player.getUniqueId();
        if (Commands.isActive(uuid) && (action.equals((Object)Action.RIGHT_CLICK_AIR) || action.equals((Object)Action.RIGHT_CLICK_BLOCK))) {
            if (item != null && item.getType() == Commands.dvanish().getType()) {
                if (item.getItemMeta().getDisplayName().equalsIgnoreCase(Commands.evanish().getItemMeta().getDisplayName())) {
                    player.performCommand("vanish on");
                    player.getInventory().setItem(7, Commands.dvanish());
                }
                if (item.getItemMeta().getDisplayName().equalsIgnoreCase(Commands.dvanish().getItemMeta().getDisplayName())) {
                    player.performCommand("vanish off");
                    player.getInventory().setItem(7, Commands.evanish());
                }
            }
            if (item != null && item.getType() == Commands.rtp().getType()) {
                Player tar = Events.getRandomPlayer(player);
                Location targetLoc = tar.getLocation();
                String target = tar.getName();
                if (item.getItemMeta().getDisplayName().equalsIgnoreCase(Commands.rtp().getItemMeta().getDisplayName())) {
                    if (tar.equals(player)) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7You are the only online player.")));
                    } else {
                        player.teleport(targetLoc);
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7You successfully teleported to " + target + ".")));
                    }
                }
            }
            if (item != null && item.getType() == Commands.list().getType() && item.getItemMeta().getDisplayName().equalsIgnoreCase(Commands.list().getItemMeta().getDisplayName())) {
                player.openInventory(Events.list(1));
            }
            if (item != null && item.getType() == Commands.help().getType() && item.getItemMeta().getDisplayName().equalsIgnoreCase(Commands.help().getItemMeta().getDisplayName())) {
                Bukkit.getOnlinePlayers().forEach(o -> {
                    if (o.hasPermission("staffmode.use")) {
                        o.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7" + player.getName() + " &7is asking for some help to spectate someone.")));
                    }
                });
            }
        }
    }

    public static Inventory list(int pageNumber) {
        Inventory list = Bukkit.createInventory(null, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)Commands.list().getItemMeta().getDisplayName()));
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        Object[] players = onlinePlayers.toArray();
        int[] pagePositions = new int[]{53 * (pageNumber - 1), 53 * pageNumber};
        int startPos = pagePositions[0];
        while (startPos < pagePositions[1] && startPos < Bukkit.getOnlinePlayers().size()) {
            Player player = (Player)players[startPos];
            int x = player.getLocation().getBlockX();
            int y = player.getLocation().getBlockY();
            int z = player.getLocation().getBlockZ();
            World world = player.getWorld();
            String playername = player.getDisplayName();
            ItemStack head = new ItemStack(Material.SKULL_ITEM);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            head.setDurability((short)3);
            meta.setOwner(playername);
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)("&d&l" + playername)));
            ArrayList<String> head_lore = new ArrayList<String>();
            head_lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&5* &dHealth: &7" + player.getHealth())));
            head_lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&5* &dLevel: &7" + player.getLevel())));
            head_lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&5* &dLocation: &7x: " + x + " &7y: " + y + " &7z: " + z + " World: " + world.getName())));
            meta.setLore(head_lore);
            head.setItemMeta((ItemMeta)meta);
            if (Bukkit.getOnlinePlayers().size() > 53) {
                ItemStack page = new ItemStack(Material.BARRIER);
                ItemMeta page_meta = page.getItemMeta();
                int newPageNumber = pageNumber + 1;
                page_meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)("&4Page: " + newPageNumber)));
                ArrayList<String> page_lore = new ArrayList<String>();
                page_lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Click to see the next page."));
                page_meta.setLore(page_lore);
                page.setItemMeta(page_meta);
                list.setItem(53, page);
            }
            list.addItem(new ItemStack[]{head});
            ++startPos;
        }
        return list;
    }

    public static Player getRandomPlayer(Player player) {
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        onlinePlayers.remove(player);
        if (onlinePlayers.size() == 0) {
            return player;
        }
        int random = new Random().nextInt(onlinePlayers.size());
        Object[] target = onlinePlayers.toArray();
        Player tar = (Player)target[random];
        return tar;
    }

    @EventHandler
    public void onPlayerHit(PlayerInteractEntityEvent event) {
        Entity ent = event.getRightClicked();
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInHand();
        UUID uuid = player.getUniqueId();
        if (Commands.isActive(uuid) && ent instanceof Player) {
            if (item.getItemMeta().getDisplayName().equalsIgnoreCase(Commands.freeze().getItemMeta().getDisplayName())) {
                if (event.getHand() == EquipmentSlot.HAND) {
                    Commands.freeze(player, (Player)ent);
                }
            } else if (item.getItemMeta().getDisplayName().equalsIgnoreCase(Commands.invsee().getItemMeta().getDisplayName())) {
                player.performCommand("invsee " + ent.getName());
            }
        }
    }

    @EventHandler
    public static void onPlayerMove(PlayerMoveEvent event) {
        String prefix = plugin.getConfig().getString("Prefix");
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (Events.isFrozen(uuid)) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7You cannot move while frozen.")));
        }
    }

    @EventHandler
    public static void onStaffInvMove(InventoryClickEvent event) {
        String prefix = plugin.getConfig().getString("Prefix");
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (Commands.isActive(uuid)) {
            ItemMeta itemMeta = event.getCurrentItem().getItemMeta();
            if (event.getCurrentItem().getType() == Material.SKULL_ITEM) {
                SkullMeta meta = (SkullMeta)itemMeta;
                String target = meta.getOwner();
                Player tar = Bukkit.getServer().getPlayer(target);
                if (Bukkit.getServer().getOfflinePlayer(target).isOnline()) {
                    player.teleport((Entity)tar);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7You successfully teleported to " + target + ".")));
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7This player isent online.")));
                }
                player.closeInventory();
                event.setCancelled(true);
            }
            if (event.getCurrentItem().getType() == Material.BARRIER) {
                String name = event.getCurrentItem().getItemMeta().getDisplayName();
                if (name.equalsIgnoreCase(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4Page: 1"))) {
                    player.openInventory(Events.list(1));
                } else if (name.equalsIgnoreCase(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4Page: 2"))) {
                    player.openInventory(Events.list(2));
                } else if (name.equalsIgnoreCase(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4Page: 3"))) {
                    player.openInventory(Events.list(3));
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public static void onStaffInvPickUp(PlayerPickupItemEvent event) {
        Player player;
        UUID uuid;
        if (event.getPlayer() instanceof Player && Commands.isActive(uuid = (player = event.getPlayer()).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public static void onStaffInvDrop(PlayerDropItemEvent event) {
        Player player;
        UUID uuid;
        String prefix = plugin.getConfig().getString("Prefix");
        if (event.getPlayer() instanceof Player && Commands.isActive(uuid = (player = event.getPlayer()).getUniqueId())) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7You cannot drop items while in staff mode.")));
        }
    }

    @EventHandler
    public static void onFreezeDamage(EntityDamageEvent event) {
        Entity ent;
        UUID uuid;
        if (event.getEntity() instanceof Player && Events.isFrozen(uuid = (ent = event.getEntity()).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public static void onFreezeDamagee(EntityDamageByEntityEvent event) {
        String prefix = plugin.getConfig().getString("Prefix");
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            Entity ent = event.getEntity();
            UUID uuid = ent.getUniqueId();
            if (Events.isFrozen(uuid)) {
                event.setCancelled(true);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + " &7You cannot attack " + ent.getName() + " while he is frozen.")));
            }
        }
    }
}

