/*
 * Decompiled with CFR 0.152.
 */
package me.pulsi_.combostick.managers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import me.pulsi_.combostick.ComboStick;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final ComboStick plugin;
    private File messagesFile;
    private File configFile;
    private FileConfiguration messages;
    private FileConfiguration config;

    public ConfigManager(ComboStick plugin) {
        this.plugin = plugin;
    }

    public void createConfigs() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "Messages.yml");
        this.configFile = new File(this.plugin.getDataFolder(), "Config.yml");
        if (!this.messagesFile.exists()) {
            this.messagesFile.getParentFile().mkdir();
            this.plugin.saveResource("Messages.yml", false);
        }
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdir();
            this.plugin.saveResource("Config.yml", false);
        }
        this.messages = new YamlConfiguration();
        this.config = new YamlConfiguration();
        try {
            this.messages.load(this.messagesFile);
            this.config.load(this.configFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void reloadConfigs() {
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }
}

