/*
 * Decompiled with CFR 0.152.
 */
package me.pulsi_.combostick.commands;

import me.pulsi_.combostick.ComboStick;
import me.pulsi_.combostick.items.Item;
import me.pulsi_.combostick.managers.MessageManager;
import me.pulsi_.combostick.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Commands
implements CommandExecutor {
    private MessageManager messageManager;
    private ComboStick plugin;
    private String version;

    public Commands(ComboStick plugin) {
        this.version = plugin.getDescription().getVersion();
        this.plugin = plugin;
        this.messageManager = new MessageManager(plugin);
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        ItemStack stick = new Item(this.plugin).getStick();
        if (args.length == 0) {
            s.sendMessage(ChatUtils.c("&3ComboStick &8v%v&3, by &fPulsi_".replace("%v", this.version)));
        }
        if (args.length == 1) {
            switch (args[0]) {
                default: {
                    this.messageManager.unknownCommand(s);
                    break;
                }
                case "help": {
                    if (s.hasPermission("combostick.help")) {
                        s.sendMessage(ChatUtils.c("&8&l&m========================================="));
                        s.sendMessage(ChatUtils.c("&b      (( &c&lCombo&f&lStick &b)) &aHelp"));
                        s.sendMessage(ChatUtils.c("&a/ComboStick help &7See this page"));
                        s.sendMessage(ChatUtils.c("&a/ComboStick reload &7Reload the plugin"));
                        s.sendMessage(ChatUtils.c("&a/ComboStick restart &7Restart the plugin"));
                        s.sendMessage(ChatUtils.c("&a/ComboStick give &7Pickup the stick"));
                        s.sendMessage(ChatUtils.c("&a/ComboStick give <player> &7Give the stick to the player"));
                        s.sendMessage(ChatUtils.c("&8&l&m========================================="));
                        break;
                    }
                    this.messageManager.noPermission(s);
                    break;
                }
                case "give": {
                    if (s.hasPermission("combostick.give")) {
                        if (s instanceof Player) {
                            Player p = (Player)s;
                            p.getInventory().addItem(new ItemStack[]{stick});
                            break;
                        }
                        s.sendMessage(ChatUtils.c("&c&lC&f&lS &cOnly In-Game players can execute this command!"));
                        break;
                    }
                    this.messageManager.noPermission(s);
                    break;
                }
                case "reload": {
                    if (s.hasPermission("combostick.reload")) {
                        this.plugin.reloadConfigs();
                        s.sendMessage(ChatUtils.c("&c&lC&f&lS &2Plugin reloaded!"));
                        break;
                    }
                    this.messageManager.noPermission(s);
                    break;
                }
                case "restart": {
                    if (s.hasPermission("combostick.restart")) {
                        this.plugin.reloadConfigs();
                        s.sendMessage(ChatUtils.c("&c&lC&f&lS &2Plugin restarted, now everything should work!"));
                        break;
                    }
                    this.messageManager.noPermission(s);
                }
            }
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            if (s.hasPermission("combostick.give")) {
                try {
                    Player target = Bukkit.getPlayerExact((String)args[1]);
                    target.getInventory().addItem(new ItemStack[]{stick});
                }
                catch (Exception e) {
                    s.sendMessage(ChatUtils.c("&c&lC&f&lS &cI can't find this player!"));
                }
            } else {
                this.messageManager.noPermission(s);
            }
        }
        return true;
    }
}

